/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.browser.spi.ProjectBrowserProvider;
import org.netbeans.spi.project.ui.CustomizerProvider2;

public class WebProjectBrowserProvider
implements ProjectBrowserProvider {
    private final Map<PropertyChangeListener, PreferenceChangeListener> mapper;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Project project;
    private Preferences preferences;

    public WebProjectBrowserProvider(Project project) {
        this.project = project;
        this.mapper = new HashMap<PropertyChangeListener, PreferenceChangeListener>();
    }

    private Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = ProjectUtils.getPreferences((Project)this.project, MavenProjectSupport.class, (boolean)false);
            this.preferences.addPreferenceChangeListener(new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    if ("netbeans.selected.browser".equals(evt.getKey())) {
                        WebProjectBrowserProvider.this.pcs.firePropertyChange("activeConfiguration", null, null);
                    }
                }
            });
        }
        return this.preferences;
    }

    public Collection<WebBrowser> getBrowsers() {
        return WebBrowsers.getInstance().getAll(false, true, true);
    }

    public WebBrowser getActiveBrowser() {
        String selectedBrowser = JavaEEProjectSettings.getBrowserID((Project)this.project);
        if (selectedBrowser == null) {
            return null;
        }
        return BrowserUISupport.getBrowser((String)selectedBrowser);
    }

    public void setActiveBrowser(final WebBrowser browser) throws IllegalArgumentException, IOException {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                JavaEEProjectSettings.setBrowserID((Project)WebProjectBrowserProvider.this.project, (String)browser.getId());
            }
        });
        this.pcs.firePropertyChange("activeConfiguration", null, null);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer("run", null);
    }

    public void addPropertyChangeListener(final PropertyChangeListener propertyListener) {
        PreferenceChangeListener preferencesListener = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                propertyListener.propertyChange(new PropertyChangeEvent(evt.getNode(), evt.getKey(), null, evt.getNewValue()));
            }
        };
        this.pcs.addPropertyChangeListener(propertyListener);
        this.getPreferences().addPreferenceChangeListener(preferencesListener);
        this.mapper.put(propertyListener, preferencesListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyListener) {
        PreferenceChangeListener preferencesListener = this.mapper.get(propertyListener);
        this.pcs.removePropertyChangeListener(propertyListener);
        this.getPreferences().removePreferenceChangeListener(preferencesListener);
        this.mapper.remove(propertyListener);
    }
}

