/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDbSystemPatchRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private String patchId;

    @ConstructorProperties(value={"dbSystemId", "patchId"})
    GetDbSystemPatchRequest(String dbSystemId, String patchId) {
        this.dbSystemId = dbSystemId;
        this.patchId = patchId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).patchId(this.patchId);
    }

    public String toString() {
        return "GetDbSystemPatchRequest(super=" + super.toString() + ", dbSystemId=" + this.getDbSystemId() + ", patchId=" + this.getPatchId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDbSystemPatchRequest)) {
            return false;
        }
        GetDbSystemPatchRequest other = (GetDbSystemPatchRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dbSystemId = this.getDbSystemId();
        String other$dbSystemId = other.getDbSystemId();
        if (this$dbSystemId == null ? other$dbSystemId != null : !this$dbSystemId.equals(other$dbSystemId)) {
            return false;
        }
        String this$patchId = this.getPatchId();
        String other$patchId = other.getPatchId();
        return !(this$patchId == null ? other$patchId != null : !this$patchId.equals(other$patchId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetDbSystemPatchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dbSystemId = this.getDbSystemId();
        result = result * 59 + ($dbSystemId == null ? 43 : $dbSystemId.hashCode());
        String $patchId = this.getPatchId();
        result = result * 59 + ($patchId == null ? 43 : $patchId.hashCode());
        return result;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbSystemPatchRequest, Void> {
        private String dbSystemId;
        private String patchId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbSystemPatchRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.patchId(o.getPatchId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbSystemPatchRequest build() {
            GetDbSystemPatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            return this;
        }

        public GetDbSystemPatchRequest buildWithoutInvocationCallback() {
            return new GetDbSystemPatchRequest(this.dbSystemId, this.patchId);
        }

        public String toString() {
            return "GetDbSystemPatchRequest.Builder(dbSystemId=" + this.dbSystemId + ", patchId=" + this.patchId + ")";
        }
    }
}

