/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.identity.model.Domain;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDomainsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String displayName;
    private String url;
    private String homeRegionUrl;
    private String type;
    private String licenseType;
    private Boolean isHiddenOnLogin;
    private String page;
    private Integer limit;
    private String name;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;
    private Domain.LifecycleState lifecycleState;

    @ConstructorProperties(value={"compartmentId", "displayName", "url", "homeRegionUrl", "type", "licenseType", "isHiddenOnLogin", "page", "limit", "name", "sortBy", "sortOrder", "opcRequestId", "lifecycleState"})
    ListDomainsRequest(String compartmentId, String displayName, String url, String homeRegionUrl, String type, String licenseType, Boolean isHiddenOnLogin, String page, Integer limit, String name, SortBy sortBy, SortOrder sortOrder, String opcRequestId, Domain.LifecycleState lifecycleState) {
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.url = url;
        this.homeRegionUrl = homeRegionUrl;
        this.type = type;
        this.licenseType = licenseType;
        this.isHiddenOnLogin = isHiddenOnLogin;
        this.page = page;
        this.limit = limit;
        this.name = name;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).displayName(this.displayName).url(this.url).homeRegionUrl(this.homeRegionUrl).type(this.type).licenseType(this.licenseType).isHiddenOnLogin(this.isHiddenOnLogin).page(this.page).limit(this.limit).name(this.name).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).lifecycleState(this.lifecycleState);
    }

    public String toString() {
        return "ListDomainsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", displayName=" + this.getDisplayName() + ", url=" + this.getUrl() + ", homeRegionUrl=" + this.getHomeRegionUrl() + ", type=" + this.getType() + ", licenseType=" + this.getLicenseType() + ", isHiddenOnLogin=" + this.getIsHiddenOnLogin() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ", name=" + this.getName() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", opcRequestId=" + this.getOpcRequestId() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDomainsRequest)) {
            return false;
        }
        ListDomainsRequest other = (ListDomainsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isHiddenOnLogin = this.getIsHiddenOnLogin();
        Boolean other$isHiddenOnLogin = other.getIsHiddenOnLogin();
        if (this$isHiddenOnLogin == null ? other$isHiddenOnLogin != null : !((Object)this$isHiddenOnLogin).equals(other$isHiddenOnLogin)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$homeRegionUrl = this.getHomeRegionUrl();
        String other$homeRegionUrl = other.getHomeRegionUrl();
        if (this$homeRegionUrl == null ? other$homeRegionUrl != null : !this$homeRegionUrl.equals(other$homeRegionUrl)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$licenseType = this.getLicenseType();
        String other$licenseType = other.getLicenseType();
        if (this$licenseType == null ? other$licenseType != null : !this$licenseType.equals(other$licenseType)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        Domain.LifecycleState this$lifecycleState = this.getLifecycleState();
        Domain.LifecycleState other$lifecycleState = other.getLifecycleState();
        return !(this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListDomainsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isHiddenOnLogin = this.getIsHiddenOnLogin();
        result = result * 59 + ($isHiddenOnLogin == null ? 43 : ((Object)$isHiddenOnLogin).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $homeRegionUrl = this.getHomeRegionUrl();
        result = result * 59 + ($homeRegionUrl == null ? 43 : $homeRegionUrl.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $licenseType = this.getLicenseType();
        result = result * 59 + ($licenseType == null ? 43 : $licenseType.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        Domain.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHomeRegionUrl() {
        return this.homeRegionUrl;
    }

    public String getType() {
        return this.type;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public Boolean getIsHiddenOnLogin() {
        return this.isHiddenOnLogin;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Domain.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDomainsRequest, Void> {
        private String compartmentId;
        private String displayName;
        private String url;
        private String homeRegionUrl;
        private String type;
        private String licenseType;
        private Boolean isHiddenOnLogin;
        private String page;
        private Integer limit;
        private String name;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String opcRequestId;
        private Domain.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDomainsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.displayName(o.getDisplayName());
            this.url(o.getUrl());
            this.homeRegionUrl(o.getHomeRegionUrl());
            this.type(o.getType());
            this.licenseType(o.getLicenseType());
            this.isHiddenOnLogin(o.getIsHiddenOnLogin());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.name(o.getName());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDomainsRequest build() {
            ListDomainsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder homeRegionUrl(String homeRegionUrl) {
            this.homeRegionUrl = homeRegionUrl;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public Builder isHiddenOnLogin(Boolean isHiddenOnLogin) {
            this.isHiddenOnLogin = isHiddenOnLogin;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder lifecycleState(Domain.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListDomainsRequest buildWithoutInvocationCallback() {
            return new ListDomainsRequest(this.compartmentId, this.displayName, this.url, this.homeRegionUrl, this.type, this.licenseType, this.isHiddenOnLogin, this.page, this.limit, this.name, this.sortBy, this.sortOrder, this.opcRequestId, this.lifecycleState);
        }

        public String toString() {
            return "ListDomainsRequest.Builder(compartmentId=" + this.compartmentId + ", displayName=" + this.displayName + ", url=" + this.url + ", homeRegionUrl=" + this.homeRegionUrl + ", type=" + this.type + ", licenseType=" + this.licenseType + ", isHiddenOnLogin=" + this.isHiddenOnLogin + ", page=" + this.page + ", limit=" + this.limit + ", name=" + this.name + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Name("NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

