/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.util.Vector;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.netbeans.modules.ant.debugger.Utils;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;

public class BreakpointModel
implements NodeModel {
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/Breakpoint";
    public static final String LINE_BREAKPOINT_PC = "org/netbeans/modules/debugger/resources/editor/Breakpoint+PC";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/editor/DisabledBreakpoint";
    private Vector<ModelListener> listeners = new Vector();

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof AntBreakpoint) {
            AntBreakpoint breakpoint = (AntBreakpoint)((Object)node);
            FileObject fileObject = (FileObject)breakpoint.getLine().getLookup().lookup(FileObject.class);
            return fileObject.getNameExt() + ":" + (breakpoint.getLine().getLineNumber() + 1);
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof AntBreakpoint) {
            AntBreakpoint breakpoint = (AntBreakpoint)((Object)node);
            if (!((AntBreakpoint)((Object)node)).isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            AntDebugger debugger = BreakpointModel.getDebugger();
            if (debugger != null && Utils.contains(debugger.getCurrentLine(), breakpoint.getLine())) {
                return LINE_BREAKPOINT_PC;
            }
            return LINE_BREAKPOINT;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof AntBreakpoint) {
            AntBreakpoint breakpoint = (AntBreakpoint)((Object)node);
            return breakpoint.getLine().getDisplayName();
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireChanges() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private static AntDebugger getDebugger() {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine == null) {
            return null;
        }
        return (AntDebugger)((Object)engine.lookupFirst(null, AntDebugger.class));
    }
}

