/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.htmlui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.htmlui.HTMLDialogBase;

@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.METHOD})
public @interface HTMLDialog {
    public String url();

    public String className() default "Pages";

    public String[] techIds() default {};

    public static final class Builder {
        private final String url;
        private List<String> techIds = new ArrayList<String>();
        private Runnable onPageLoad;

        private Builder(String u) {
            this.url = u;
        }

        public static Builder newDialog(String url) {
            return new Builder(url);
        }

        public Builder loadFinished(Runnable run) {
            this.onPageLoad = run;
            return this;
        }

        public Builder addTechIds(String ... ids) {
            this.techIds.addAll(Arrays.asList(ids));
            return this;
        }

        public String showAndWait() {
            HTMLDialogBase impl = HTMLDialogBase.create(this.url, this.onPageLoad, null, this.techIds.toArray(new String[0]), null);
            return impl.showAndWait();
        }

        public void show(OnSubmit s) {
            HTMLDialogBase impl = HTMLDialogBase.create(this.url, this.onPageLoad, s, this.techIds.toArray(new String[0]), null);
            impl.show(s);
        }

        public <C> C component(Class<C> type) {
            HTMLDialogBase impl = HTMLDialogBase.create(this.url, this.onPageLoad, null, this.techIds.toArray(new String[0]), type);
            return impl.component(type);
        }
    }

    @FunctionalInterface
    public static interface OnSubmit {
        public boolean onSubmit(String var1);
    }
}

