/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.netbeans.modules.websvc.api.customization.model.BindingCustomization;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.api.customization.model.EnableMIMEContent;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class BindingPanel
extends SaveableSectionInnerPanel {
    private Binding binding;
    private WSDLModel model;
    private boolean wsdlDirty;
    private ModelChangeListener modelListener;
    private BindingActionListener actionListener;
    private Definitions primaryDefinitions;
    private ButtonGroup emcButtonGroup;
    private JCheckBox enableMIMEContentCB;

    public BindingPanel(SectionView view, Binding binding, Definitions primaryDefinitions) {
        super(view);
        this.binding = binding;
        this.primaryDefinitions = primaryDefinitions;
        this.model = this.binding.getModel();
        this.initComponents();
        this.sync();
        this.modelListener = new ModelChangeListener();
        WSDLModel primaryModel = primaryDefinitions.getModel();
        PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)primaryModel);
        primaryModel.addPropertyChangeListener(pcl);
        this.actionListener = new BindingActionListener();
        ActionListener al = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.actionListener, (Object)this.enableMIMEContentCB);
        this.enableMIMEContentCB.addActionListener(al);
    }

    private boolean getMIMEContentOfParent() {
        DefinitionsCustomization dc;
        EnableMIMEContent mimeContent;
        List dcs = this.primaryDefinitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (dcs.size() > 0 && (mimeContent = (dc = (DefinitionsCustomization)dcs.get(0)).getEnableMIMEContent()) != null) {
            return mimeContent.isEnabled();
        }
        return false;
    }

    private void sync() {
        List ee = this.binding.getExtensibilityElements(BindingCustomization.class);
        if (ee.size() == 1) {
            BindingCustomization bc = (BindingCustomization)ee.get(0);
            EnableMIMEContent emc = bc.getEnableMIMEContent();
            if (emc != null) {
                this.setEnableMIMEContent(emc.isEnabled());
            } else {
                this.setEnableMIMEContent(this.getMIMEContentOfParent());
            }
        } else {
            this.setEnableMIMEContent(this.getMIMEContentOfParent());
        }
    }

    public void setEnableMIMEContent(boolean enable) {
        this.enableMIMEContentCB.setSelected(enable);
    }

    public boolean getEnableMIMEContent() {
        return this.enableMIMEContentCB.isSelected();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        block13: {
            List ee = this.binding.getExtensibilityElements(BindingCustomization.class);
            CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
            try {
                if (jComponent != this.enableMIMEContentCB) break block13;
                if (ee.size() > 0) {
                    BindingCustomization bc = (BindingCustomization)ee.get(0);
                    EnableMIMEContent emc = bc.getEnableMIMEContent();
                    if (emc == null) {
                        try {
                            this.model.startTransaction();
                            emc = factory.createEnableMIMEContent(this.model);
                            emc.setEnabled(this.getEnableMIMEContent());
                            bc.setEnableMIMEContent(emc);
                            this.wsdlDirty = true;
                            break block13;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    try {
                        this.model.startTransaction();
                        emc.setEnabled(this.getEnableMIMEContent());
                        this.wsdlDirty = true;
                        break block13;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                BindingCustomization bc = factory.createBindingCustomization(this.model);
                EnableMIMEContent emc = factory.createEnableMIMEContent(this.model);
                try {
                    this.model.startTransaction();
                    emc.setEnabled(this.getEnableMIMEContent());
                    bc.setEnableMIMEContent(emc);
                    this.binding.addExtensibilityElement((ExtensibilityElement)bc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
            catch (IllegalStateException ex) {
                Exceptions.attachSeverity((Throwable)ex, (Level)Level.WARNING);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.emcButtonGroup = new ButtonGroup();
        this.enableMIMEContentCB = new JCheckBox();
        this.enableMIMEContentCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_MIME_CONTENT").charAt(0));
        this.enableMIMEContentCB.setText(NbBundle.getBundle(BindingPanel.class).getString("LBL_ENABLE_MIME_CONTENT"));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.enableMIMEContentCB.setToolTipText(bundle.getString("TOOLTIP_ENABLE_MIME"));
        this.enableMIMEContentCB.setActionCommand(bundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableMIMEContentCB.setContentAreaFilled(false);
        this.enableMIMEContentCB.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.enableMIMEContentCB).addContainerGap(409, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.enableMIMEContentCB).addContainerGap(30, Short.MAX_VALUE)));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ENABLE_MIME_CONTENT"));
    }

    class BindingActionListener
    implements ActionListener {
        BindingActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BindingPanel.this.setValue((JComponent)e.getSource(), null);
        }
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EnableMIMEContent emc;
            WSDLComponent parent;
            Object source = evt.getSource();
            if (source instanceof EnableMIMEContent && (parent = (WSDLComponent)(emc = (EnableMIMEContent)source).getParent()) instanceof DefinitionsCustomization) {
                BindingPanel.this.sync();
            }
        }
    }
}

