/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.IssueContainerImpl;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.SPIAccessor;
import org.netbeans.modules.bugtracking.api.Query;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.team.spi.OwnerInfo;

public final class QueryImpl<Q, I> {
    private final RepositoryImpl<?, Q, I> repository;
    private final QueryProvider<Q, I> queryProvider;
    private final IssueProvider<I> issueProvider;
    private Query query;
    private final Q data;
    private final IssueContainerIntern issueContainer;
    private boolean wasRefreshed = false;
    public static final String EVENT_QUERY_REFRESH_STARTED = "bugtracking.query.refresh.started";
    public static final String EVENT_QUERY_REFRESH_FINISHED = "bugtracking.query.refresh.finished";
    public static final String EVENT_QUERY_RESTORE_STARTED = "bugtracking.query.restore.started";
    public static final String EVENT_QUERY_RESTORE_FINISHED = "bugtracking.query.restore.finished";

    QueryImpl(RepositoryImpl repository, QueryProvider<Q, I> queryProvider, IssueProvider<I> issueProvider, Q data) {
        this.queryProvider = queryProvider;
        this.issueProvider = issueProvider;
        this.data = data;
        this.repository = repository;
        this.issueContainer = new IssueContainerIntern(repository);
        this.issueContainer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (QueryImpl.EVENT_QUERY_REFRESH_STARTED.equals(evt.getPropertyName())) {
                    QueryImpl.this.wasRefreshed = true;
                    QueryImpl.this.issueContainer.removePropertyChangeListener(this);
                }
            }
        });
        queryProvider.setIssueContainer(data, SPIAccessor.IMPL.createIssueContainer(this.issueContainer));
    }

    public synchronized Query getQuery() {
        if (this.query == null) {
            this.query = APIAccessor.IMPL.createQuery(this);
        }
        return this.query;
    }

    public RepositoryImpl<?, Q, I> getRepositoryImpl() {
        return this.repository;
    }

    public Collection<IssueImpl> getIssues() {
        return this.issueContainer.getIssues();
    }

    public void open(QueryController.QueryMode mode) {
        QueryAction.openQuery(this, this.repository, mode);
    }

    public boolean canRemove() {
        return this.queryProvider.canRemove(this.data);
    }

    public void remove() {
        this.queryProvider.remove(this.data);
    }

    public boolean canRename() {
        return this.queryProvider.canRename(this.data);
    }

    public void rename(String newName) {
        this.queryProvider.rename(this.data, newName);
    }

    public String getTooltip() {
        return this.queryProvider.getTooltip(this.data);
    }

    public void refresh() {
        this.queryProvider.refresh(this.data);
    }

    public boolean wasRefreshed() {
        return this.wasRefreshed;
    }

    public String getDisplayName() {
        return this.queryProvider.getDisplayName(this.data);
    }

    public QueryController getController() {
        return this.queryProvider.getController(this.data);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.issueContainer.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.issueContainer.removePropertyChangeListener(listener);
    }

    public void setContext(OwnerInfo info) {
        this.repository.setQueryContext(this.data, info);
    }

    public boolean isData(Object obj) {
        return this.data == obj;
    }

    public boolean providesMode(QueryController.QueryMode queryMode) {
        QueryController controller = this.queryProvider.getController(this.data);
        return controller != null ? controller.providesMode(queryMode) : false;
    }

    Q getData() {
        return this.data;
    }

    private static class IssueImplComparator
    implements Comparator<IssueImpl> {
        private IssueImplComparator() {
        }

        @Override
        public int compare(IssueImpl o1, IssueImpl o2) {
            if (o1 == null || o2 == null) {
                return o1 != null ? 1 : (o2 == null ? 0 : -1);
            }
            String id1 = o1.getID();
            String id2 = o2.getID();
            return id1 == null ? (id2 == null ? 0 : -1) : (id2 == null ? 1 : id1.compareTo(id2));
        }
    }

    private static class IssueContainerIntern<I>
    implements IssueContainerImpl<I> {
        private final PropertyChangeSupport support;
        private final Set<IssueImpl> issueImpls = new ConcurrentSkipListSet<IssueImpl>(new IssueImplComparator());
        private boolean isRunning = false;
        private final RepositoryImpl repository;

        public IssueContainerIntern(RepositoryImpl repository) {
            this.repository = repository;
            this.support = new PropertyChangeSupport(repository.getData());
        }

        @Override
        public void refreshingStarted() {
            this.isRunning = true;
            this.support.firePropertyChange(QueryImpl.EVENT_QUERY_REFRESH_STARTED, null, null);
        }

        @Override
        public void refreshingFinished() {
            this.isRunning = false;
            this.support.firePropertyChange(QueryImpl.EVENT_QUERY_REFRESH_FINISHED, null, null);
            this.support.firePropertyChange("bugtracking.query.finished", null, null);
        }

        @Override
        public void restoreStarted() {
            this.isRunning = true;
            this.support.firePropertyChange(QueryImpl.EVENT_QUERY_RESTORE_STARTED, null, null);
        }

        @Override
        public void restoreFinished() {
            this.isRunning = false;
            this.support.firePropertyChange(QueryImpl.EVENT_QUERY_RESTORE_FINISHED, null, null);
            this.support.firePropertyChange("bugtracking.query.finished", null, null);
        }

        @Override
        public void add(I ... issues) {
            for (I i : issues) {
                IssueImpl issue = this.repository.getIssue(i);
                if (issue == null) continue;
                this.issueImpls.add(issue);
            }
        }

        @Override
        public void remove(I ... issues) {
            for (I i : issues) {
                IssueImpl issue = this.repository.getIssue(i);
                if (issue == null) continue;
                this.issueImpls.remove(issue);
            }
        }

        @Override
        public void clear() {
            this.issueImpls.clear();
        }

        Collection<IssueImpl> getIssues() {
            return Collections.unmodifiableCollection(this.issueImpls);
        }

        void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
            if (this.isRunning) {
                listener.propertyChange(new PropertyChangeEvent(this.repository.getData(), QueryImpl.EVENT_QUERY_REFRESH_STARTED, null, null));
            }
        }

        void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }
    }
}

