/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.settings;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.settings.DashboardSettings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DashboardOptions
extends JPanel
implements DocumentListener {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean dataValid;
    private JCheckBox cbLimit;
    private JCheckBox cbLimitCategory;
    private JCheckBox cbLimitQuery;
    private JCheckBox cbSync;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblError;
    private JTextField txtLimitNumber;
    private JTextField txtSync;

    public DashboardOptions() {
        this.initComponents();
        this.lblError.setVisible(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.txtSync = new JTextField();
        this.jLabel4 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.txtLimitNumber = new JTextField();
        this.jLabel5 = new JLabel();
        this.lblError = new JLabel();
        this.jLabel6 = new JLabel();
        this.cbLimit = new JCheckBox();
        this.cbLimitCategory = new JCheckBox();
        this.cbLimitQuery = new JCheckBox();
        this.cbSync = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DashboardOptions.class, (String)"DashboardOptions.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DashboardOptions.class, (String)"DashboardOptions.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DashboardOptions.class, (String)"DashboardOptions.jLabel5.text"));
        this.lblError.setForeground(Color.red);
        this.lblError.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugtracking/tasks/resources/error.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(DashboardOptions.class, (String)"DashboardOptions.jLabel6.text"));
        this.cbLimit.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbLimit, (String)NbBundle.getMessage(DashboardOptions.class, (String)"DashboardOptions.cbLimit.text"));
        this.cbLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardOptions.this.cbLimitActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbLimitCategory, (String)NbBundle.getMessage(DashboardOptions.class, (String)"DashboardOptions.cbLimitCategory.text"));
        this.cbLimitQuery.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbLimitQuery, (String)NbBundle.getMessage(DashboardOptions.class, (String)"DashboardOptions.cbLimitQuery.text"));
        this.cbSync.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbSync, (String)NbBundle.getMessage(DashboardOptions.class, (String)"DashboardOptions.cbSync.text"));
        this.cbSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardOptions.this.cbSyncActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbLimit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtLimitNumber, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addComponent(this.cbSync).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSync, -2, 46, -2)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbLimitQuery).addComponent(this.cbLimitCategory))))).addComponent(this.lblError)).addGap(0, 134, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.jSeparator1, -2, 10, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtSync, -2, -1, -2).addComponent(this.cbSync)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel4).addComponent(this.jSeparator2, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtLimitNumber, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.cbLimit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbLimitCategory).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLimitQuery).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblError).addContainerGap()));
    }

    private void cbSyncActionPerformed(ActionEvent evt) {
        this.txtSync.setEnabled(this.cbSync.isSelected());
        this.validate(true);
    }

    private void cbLimitActionPerformed(ActionEvent evt) {
        this.txtLimitNumber.setEnabled(this.cbLimit.isSelected());
        this.cbLimitCategory.setEnabled(this.cbLimit.isSelected());
        this.cbLimitQuery.setEnabled(this.cbLimit.isSelected());
        this.validate(true);
    }

    public PropertyChangeSupport getPropertySupport() {
        return this.support;
    }

    public void update() {
        this.txtLimitNumber.getDocument().removeDocumentListener(this);
        this.txtSync.getDocument().removeDocumentListener(this);
        this.loadSettings();
        this.txtLimitNumber.getDocument().addDocumentListener(this);
        this.txtSync.getDocument().addDocumentListener(this);
        this.validate(false);
    }

    public void applyChanges() {
        DashboardSettings settings = DashboardSettings.getInstance();
        boolean autoSync = this.cbSync.isSelected();
        settings.setAutoSync(autoSync, false);
        settings.setAutoSyncValue(Integer.parseInt(this.txtSync.getText().trim()), true);
        boolean tasksLimit = this.cbLimit.isSelected();
        settings.setTasksLimit(tasksLimit, false);
        settings.setTasksLimitValue(Integer.parseInt(this.txtLimitNumber.getText().trim()), false);
        settings.setTasksLimitCategory(this.cbLimitCategory.isSelected(), false);
        settings.setTasksLimitQuery(this.cbLimitQuery.isSelected(), true);
    }

    public void cancel() {
    }

    public boolean isDataValid() {
        this.validate(false);
        return this.dataValid;
    }

    public boolean isChanged() {
        DashboardSettings settings = DashboardSettings.getInstance();
        return this.cbSync.isSelected() != settings.isAutoSync() || !this.txtSync.getText().trim().equals(settings.getAutoSyncValue() + "") || !this.cbLimit.isSelected() == settings.isTasksLimit() || !this.txtLimitNumber.getText().trim().equals(settings.getTasksLimitValue() + "") || !this.cbLimitCategory.isSelected() == settings.isTasksLimitCategory() || !this.cbLimitQuery.isSelected() == settings.isTasksLimitQuery();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validate(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validate(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validate(true);
    }

    private void validate(boolean fireEvents) {
        boolean oldValid = this.dataValid;
        this.lblError.setVisible(false);
        this.lblError.setText("");
        String limit = this.txtLimitNumber.getText().trim();
        String sync = this.txtSync.getText().trim();
        this.dataValid = !(!this.isValidNumberValue(limit) && this.cbLimit.isSelected() || !this.isValidNumberValue(sync) && this.cbSync.isSelected());
        this.lblError.setVisible(!this.dataValid);
        if (fireEvents && oldValid != this.dataValid) {
            this.support.firePropertyChange(new PropertyChangeEvent(this, "valid", oldValid, this.dataValid));
        }
    }

    private boolean isValidNumberValue(String text) {
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            this.lblError.setText(NbBundle.getMessage(DashboardOptions.class, (String)"LBL_INVALID_VALUE"));
            return false;
        }
        return true;
    }

    private void loadSettings() {
        DashboardSettings settings = DashboardSettings.getInstance();
        boolean autoSync = settings.isAutoSync();
        this.cbSync.setSelected(autoSync);
        this.txtSync.setText(settings.getAutoSyncValue() + "");
        this.txtSync.setEnabled(autoSync);
        boolean tasksLimit = settings.isTasksLimit();
        this.cbLimit.setSelected(tasksLimit);
        this.txtLimitNumber.setText(settings.getTasksLimitValue() + "");
        this.txtLimitNumber.setEnabled(tasksLimit);
        this.cbLimitCategory.setSelected(settings.isTasksLimitCategory());
        this.cbLimitCategory.setEnabled(tasksLimit);
        this.cbLimitQuery.setSelected(settings.isTasksLimitQuery());
        this.cbLimitQuery.setEnabled(tasksLimit);
    }
}

