/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc.ui.options;

import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.phpdoc.PhpDocScript;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class PhpDocOptions {
    private static final String PREFERENCES_PATH = "phpdoc";
    private static final PhpDocOptions INSTANCE = new PhpDocOptions();
    private static final String PHPDOC = "phpdoc";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile boolean phpDocSearched = false;

    private PhpDocOptions() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                PhpDocOptions.this.changeSupport.fireChange();
            }
        });
    }

    public static PhpDocOptions getInstance() {
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public synchronized String getPhpDoc() {
        String phpDoc = this.getPreferences().get("phpdoc", null);
        if (phpDoc == null && !this.phpDocSearched) {
            this.phpDocSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"phpdoc", PhpDocScript.SCRIPT_NAME_LONG, "phpDocumentor.phar"});
            if (!scripts.isEmpty()) {
                phpDoc = (String)scripts.get(0);
                this.setPhpDoc(phpDoc);
            }
        }
        return phpDoc;
    }

    public void setPhpDoc(String phpDoc) {
        this.getPreferences().put("phpdoc", phpDoc);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(PhpDocOptions.class).node("phpdoc");
    }
}

