/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.ChangeTypeFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public final class ChangeType
implements ErrorRule<Void> {
    private static Set<String> codes = new HashSet<String>();

    static void computeType(CompilationInfo info, int offset, TypeMirror[] tm, TypeMirror[] expressionType, Tree[] leaf) {
        TreePath path = info.getTreeUtilities().pathFor(offset);
        if (path != null) {
            Tree scope = path.getLeaf();
            TypeMirror expected = null;
            TypeMirror resolved = null;
            if (scope.getKind() == Tree.Kind.ASSIGNMENT) {
                if ((path = path.getParentPath()) != null) {
                    scope = path.getLeaf();
                }
            } else if (scope.getKind() == Tree.Kind.MEMBER_SELECT) {
                if ((path = path.getParentPath()) != null && (scope = path.getLeaf()).getKind() == Tree.Kind.METHOD_INVOCATION && (path = path.getParentPath()) != null) {
                    scope = path.getLeaf();
                }
            } else if (scope.getKind() == Tree.Kind.IDENTIFIER && (path = path.getParentPath()) != null && ((scope = path.getLeaf()).getKind() == Tree.Kind.MEMBER_SELECT || scope.getKind() == Tree.Kind.METHOD_INVOCATION) && (path = path.getParentPath()) != null) {
                scope = path.getLeaf();
            }
            if (scope.getKind() == Tree.Kind.ENHANCED_FOR_LOOP) {
                EnhancedForLoopTree efl = (EnhancedForLoopTree)scope;
                path = new TreePath(path, efl.getVariable());
                scope = efl.getVariable();
                resolved = Utilities.getIterableGenericType(info, new TreePath(path, efl.getExpression()));
            }
            if (scope.getKind() == Tree.Kind.VARIABLE) {
                if (((VariableTree)scope).getInitializer() != null) {
                    resolved = info.getTrees().getTypeMirror(new TreePath(path, ((VariableTree)scope).getInitializer()));
                }
                expected = info.getTrees().getTypeMirror(path);
            }
            if (expected != null && resolved != null && (resolved = Utilities.resolveTypeForDeclaration(info, resolved)) != null && resolved.getKind() != TypeKind.VOID && resolved.getKind() != TypeKind.NONE && resolved.getKind() != TypeKind.EXECUTABLE && resolved.getKind() != TypeKind.NULL && resolved.getKind() != TypeKind.ERROR && expected.getKind() != TypeKind.ERROR) {
                tm[0] = expected;
                expressionType[0] = resolved;
                leaf[0] = scope;
            }
        }
    }

    public Set<String> getCodes() {
        return codes;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        ArrayList<Fix> result = new ArrayList<Fix>();
        TypeMirror[] tm = new TypeMirror[1];
        TypeMirror[] expressionType = new TypeMirror[1];
        Tree[] leaf = new Tree[1];
        ChangeType.computeType(info, offset, tm, expressionType, leaf);
        if (leaf[0] instanceof VariableTree && tm[0] != null) {
            VariableTree vt = (VariableTree)leaf[0];
            if (treePath != null && treePath.getLeaf() == vt.getInitializer() && treePath.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                return null;
            }
            expressionType[0] = Utilities.convertIfAnonymous(expressionType[0]);
            result.add(new ChangeTypeFix(info, treePath, ((VariableTree)leaf[0]).getName().toString(), org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)expressionType[0], (boolean)false).toString(), offset).toEditorFix());
        }
        return result;
    }

    public void cancel() {
    }

    public String getId() {
        return ChangeType.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ChangeType.class, (String)"MSG_ChangeVariablesTypeDisplayName");
    }

    public String getDescription() {
        return NbBundle.getMessage(ChangeType.class, (String)"MSG_ChangeVariablesTypeDescription");
    }

    static {
        codes = new HashSet<String>();
        codes.add("compiler.err.prob.found.req");
        codes.add("compiler.err.incomparable.types");
        codes = Collections.unmodifiableSet(codes);
    }
}

