/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.FeatureList;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.NBSLanguageReader;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.Parser;

public class LanguageImpl
extends Language {
    public static final String IMPORT_FEATURE = "IMPORT";
    private NBSLanguageReader reader;
    private String mimeType;
    private Parser parser;
    private LLSyntaxAnalyser analyser;
    private FeatureList featureList = new FeatureList();
    private EventListenerList listenerList = new EventListenerList();
    private Map<String, Integer> tokenTypeToID;
    private Map<Integer, String> idToTokenType;
    private int tokenTypeCount = 0;
    private Map<String, Integer> ntToNTID;
    private Map<Integer, String> ntidToNt;
    private Feature preprocessorImport;
    private Map<String, Feature> tokenImports = new HashMap<String, Feature>();
    private List<Language> importedLangauges = new ArrayList<Language>();
    private Object INIT_LOCK = new Object();

    public LanguageImpl(String mimeType, NBSLanguageReader reader) {
        this.mimeType = mimeType;
        this.reader = reader;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public LLSyntaxAnalyser getAnalyser() {
        if (this.analyser == null) {
            this.analyser = LLSyntaxAnalyser.createEmpty(this);
        }
        return this.analyser;
    }

    @Override
    public FeatureList getFeatureList() {
        return this.featureList;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    @Override
    public int getTokenID(String tokenType) {
        if (!this.tokenTypeToID.containsKey(tokenType)) {
            return -1;
        }
        return this.tokenTypeToID.get(tokenType);
    }

    @Override
    public int getTokenTypeCount() {
        return this.tokenTypeCount;
    }

    @Override
    public String getTokenType(int tokenTypeID) {
        if (this.idToTokenType == null) {
            return null;
        }
        return this.idToTokenType.get(tokenTypeID);
    }

    @Override
    public int getNTID(String nt) {
        if (this.ntidToNt == null) {
            this.ntidToNt = new HashMap<Integer, String>();
        }
        if (this.ntToNTID == null) {
            this.ntToNTID = new HashMap<String, Integer>();
        }
        if (!this.ntToNTID.containsKey(nt)) {
            int id = this.ntToNTID.size();
            this.ntToNTID.put(nt, id);
            this.ntidToNt.put(id, nt);
        }
        return this.ntToNTID.get(nt);
    }

    @Override
    public int getNTCount() {
        if (this.ntToNTID == null) {
            return 0;
        }
        return this.ntToNTID.size();
    }

    @Override
    public String getNT(int ntid) {
        return this.ntidToNt.get(ntid);
    }

    @Override
    public Feature getPreprocessorImport() {
        return this.preprocessorImport;
    }

    @Override
    public Map<String, Feature> getTokenImports() {
        return this.tokenImports;
    }

    @Override
    public List<Language> getImportedLanguages() {
        return this.importedLangauges;
    }

    void importLanguage(Feature feature) {
        String mimeType = (String)feature.getValue("mimeType");
        if (feature.getPattern("start") != null) {
            assert (this.preprocessorImport == null);
            this.preprocessorImport = feature;
            try {
                this.importedLangauges.add(LanguagesManager.getDefault().getLanguage(mimeType));
            }
            catch (LanguageDefinitionNotFoundException ex) {
                this.importedLangauges.add(Language.create(mimeType));
            }
            return;
        }
        if (feature.getValue("state") == null) {
            String tokenName = feature.getSelector().getAsString();
            assert (!this.tokenImports.containsKey(tokenName));
            this.tokenImports.put(tokenName, feature);
            try {
                this.importedLangauges.add(LanguagesManager.getDefault().getLanguage(mimeType));
            }
            catch (LanguageDefinitionNotFoundException ex) {
                this.importedLangauges.add(Language.create(mimeType));
            }
            return;
        }
        try {
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            String state = (String)feature.getValue("state");
            String tokenName = feature.getSelector().getAsString();
            if (language.getAnalyser() != null) {
                try {
                    this.analyser = LLSyntaxAnalyser.create(this, language.getAnalyser().getRules(), language.getAnalyser().getSkipTokenTypes());
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            }
            this.featureList.importFeatures(language.getFeatureList());
            this.importedLangauges.addAll(language.getImportedLanguages());
            this.tokenImports.putAll(language.getTokenImports());
        }
        catch (LanguageDefinitionNotFoundException ex) {
            Utils.notify("Editors/" + mimeType + "/language.nbs:", ex);
        }
    }

    public void read(NBSLanguageReader reader) throws ParseException, IOException {
        this.reader = reader;
        this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ASTNode parse(InputStream is) throws IOException, ParseException {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            if (this.tokenTypeToID == null) {
                try {
                    this.INIT_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return super.parse(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws ParseException, IOException {
        try {
            this.tokenTypeToID = new HashMap<String, Integer>();
            this.idToTokenType = new HashMap<Integer, String>();
            this.featureList = new FeatureList();
            if (!this.reader.containsTokens()) {
                org.netbeans.api.lexer.Language lexerLanguage = org.netbeans.api.lexer.Language.find((String)this.getMimeType());
                if (lexerLanguage != null) {
                    for (TokenId tokenId : lexerLanguage.tokenIds()) {
                        int id = tokenId.ordinal();
                        String name = tokenId.name();
                        this.idToTokenType.put(id, name);
                        this.tokenTypeToID.put(name, id);
                        this.tokenTypeCount = Math.max(this.tokenTypeCount, id + 1);
                    }
                } else {
                    this.initLexicalStuff(this.reader.getTokenTypes());
                }
            } else {
                this.initLexicalStuff(this.reader.getTokenTypes());
            }
            List<Feature> features = this.reader.getFeatures();
            for (Feature feature : features) {
                if (feature.getFeatureName().equals(IMPORT_FEATURE)) {
                    this.importLanguage(feature);
                }
                this.featureList.add(feature);
            }
            HashSet<Integer> skipTokenIDs = new HashSet<Integer>();
            for (Feature feature : this.featureList.getFeatures("SKIP")) {
                if (!feature.getFeatureName().equals("SKIP")) continue;
                skipTokenIDs.add(this.tokenTypeToID.get(feature.getSelector().toString()));
            }
            List<Rule> rules = this.reader.getRules(this);
            this.analyser = LLSyntaxAnalyser.create(this, rules, skipTokenIDs);
            this.fire();
            Object object = this.INIT_LOCK;
            synchronized (object) {
                this.INIT_LOCK.notifyAll();
            }
        }
        finally {
            this.reader = null;
        }
    }

    private void initLexicalStuff(List<TokenType> tokenTypes) {
        for (TokenType tokenType : tokenTypes) {
            int id = tokenType.getTypeID();
            String name = tokenType.getType();
            this.idToTokenType.put(id, name);
            this.tokenTypeToID.put(name, id);
            this.tokenTypeCount = Math.max(this.tokenTypeCount, id + 1);
        }
        this.parser = Parser.create(tokenTypes);
    }

    protected void fire() {
        if (this.listenerList == null) {
            return;
        }
        Object[] l = this.listenerList.getListenerList();
        PropertyChangeEvent event = null;
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (event == null) {
                event = new PropertyChangeEvent(this, null, null, null);
            }
            ((PropertyChangeListener)l[i + 1]).propertyChange(event);
        }
    }

    public String toString() {
        return "LanguageImpl " + this.mimeType + " (" + this.hashCode() + ")";
    }
}

