/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.java.j2seproject.api.J2SEProjectPlatform;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectPropertiesUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class JWSProjectOpenHook
extends ProjectOpenedHook {
    private static final Logger LOG = Logger.getLogger(JWSProjectOpenHook.class.getName());
    private final Project prj;
    private final J2SEPropertyEvaluator eval;
    private final PlatformListener listener;

    public JWSProjectOpenHook(Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        this.prj = (Project)lkp.lookup(Project.class);
        Parameters.notNull((CharSequence)"prj", (Object)this.prj);
        this.eval = (J2SEPropertyEvaluator)lkp.lookup(J2SEPropertyEvaluator.class);
        Parameters.notNull((CharSequence)"eval", (Object)this.eval);
        this.listener = new PlatformListener((J2SEProjectPlatform)lkp.lookup(J2SEProjectPlatform.class));
    }

    protected void projectOpened() {
        this.listener.attach();
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                JWSProjectOpenHook.this.updateBuildScript();
                JWSProjectOpenHook.this.updateLibraries();
            }
        });
    }

    private void updateBuildScript() {
        AntBuildExtender extender = (AntBuildExtender)this.prj.getLookup().lookup(AntBuildExtender.class);
        if (extender == null) {
            LOG.log(Level.WARNING, "The project {0} ({1}) does not support AntBuildExtender.", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
            return;
        }
        if (extender.getExtension(JWSProjectPropertiesUtils.getCurrentExtensionName()) == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "The project {0} ({1}) does not have a current version ({2}) of JWS extension.", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory()), JWSProjectPropertiesUtils.getCurrentExtensionName()});
            }
            return;
        }
        if (JWSProjectPropertiesUtils.isJnlpImplUpToDate(this.prj)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "The project {0} ({1}) have an up to date JWS extension.", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
            }
            return;
        }
        try {
            JWSProjectPropertiesUtils.copyJnlpImplTemplate(this.prj);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateLibraries() {
        try {
            if (this.isWebStartEnabled()) {
                JWSProjectProperties.updateOnOpen(this.prj, this.eval.evaluator());
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    private boolean isWebStartEnabled() {
        return JWSProjectOpenHook.isTrue(this.eval.evaluator().getProperty("jnlp.enabled"));
    }

    protected void projectClosed() {
        this.listener.detach();
    }

    private static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    private final class PlatformListener
    implements PropertyChangeListener {
        private final J2SEProjectPlatform projectPlatform;
        private final AtomicBoolean attached = new AtomicBoolean();

        PlatformListener(J2SEProjectPlatform projectPlatform) {
            Parameters.notNull((CharSequence)"projectPlatform", (Object)projectPlatform);
            this.projectPlatform = projectPlatform;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("projectPlatform".equals(evt.getPropertyName()) && JWSProjectOpenHook.this.isWebStartEnabled()) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (ProjectManager.mutex().isWriteAccess()) {
                            JWSProjectOpenHook.this.updateLibraries();
                        } else {
                            ProjectManager.mutex().postWriteRequest((Runnable)this);
                        }
                    }
                };
                ProjectManager.mutex().postReadRequest(r);
            }
        }

        void attach() {
            if (!this.attached.compareAndSet(false, true)) {
                throw new IllegalStateException(String.format("Listener %d is already attached to J2SEProjectPlatform %d for Project %s.", System.identityHashCode(this), System.identityHashCode(this.projectPlatform), ProjectUtils.getInformation((Project)JWSProjectOpenHook.this.prj).getDisplayName()));
            }
            this.projectPlatform.addPropertyChangeListener((PropertyChangeListener)this);
        }

        void detach() {
            if (!this.attached.compareAndSet(true, false)) {
                throw new IllegalStateException(String.format("Listener %d is not attached to J2SEProjectPlatform %d for Project %s.", System.identityHashCode(this), System.identityHashCode(this.projectPlatform), ProjectUtils.getInformation((Project)JWSProjectOpenHook.this.prj).getDisplayName()));
            }
            this.projectPlatform.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }
}

