/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.ApiFeature;
import java.util.Arrays;
import java.util.List;

public enum Bitness implements ApiFeature
{
    BIT_32("32 Bit", "32", 32),
    BIT_64("64 Bit", "64", 64),
    NONE("-", "", 0),
    NOT_FOUND("", "", 0);

    private final String uiString;
    private final String apiString;
    private final int bits;

    private Bitness(String uiString, String apiString, int bits) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.bits = bits;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Bitness getDefault() {
        return NONE;
    }

    @Override
    public Bitness getNotFound() {
        return NOT_FOUND;
    }

    public Bitness[] getAll() {
        return Bitness.values();
    }

    public int getAsInt() {
        return this.bits;
    }

    public String getAsString() {
        return Integer.toString(this.bits);
    }

    public static Bitness fromText(String text) {
        switch (text) {
            case "32": 
            case "32bit": 
            case "32Bit": 
            case "32BIT": {
                return BIT_32;
            }
            case "64": 
            case "64bit": 
            case "64Bit": 
            case "64BIT": {
                return BIT_64;
            }
        }
        return NOT_FOUND;
    }

    public static Bitness fromInt(Integer bits) {
        switch (bits) {
            case 32: {
                return BIT_32;
            }
            case 64: {
                return BIT_64;
            }
        }
        return NOT_FOUND;
    }

    public static List<Bitness> getAsList() {
        return Arrays.asList(Bitness.values());
    }
}

