/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.ApiFeature;
import java.util.Arrays;
import java.util.List;

public enum Scope implements ApiFeature
{
    PUBLIC("Public", "public"),
    DIRECTLY_DOWNLOADABLE("Directly downloadable", "directly_downloadable"),
    NOT_DIRECTLY_DOWNLOADABLE("Not directly downloadable", "not_directly_downloadable"),
    BUILD_OF_OPEN_JDK("Build of OpenJDK", "build_of_openjdk"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private Scope(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Scope getDefault() {
        return NONE;
    }

    @Override
    public Scope getNotFound() {
        return NOT_FOUND;
    }

    public Scope[] getAll() {
        return Scope.values();
    }

    public static Scope fromText(String text) {
        switch (text) {
            case "public": 
            case "PUBLIC": {
                return PUBLIC;
            }
            case "directly_downloadable": 
            case "DIRECTLY_DOWNLOADABLE": 
            case "direct_download": 
            case "DIRECT_DOWNLOAD": {
                return DIRECTLY_DOWNLOADABLE;
            }
            case "not_directly_downloadable": 
            case "NOT_DIRECTLY_DOWNLOADABLE": 
            case "no_direct_download": 
            case "NO_DIRECT_DOWNLOAD": {
                return NOT_DIRECTLY_DOWNLOADABLE;
            }
            case "build_of_openjdk": 
            case "BUILD_OF_OPENJDK": 
            case "build_of_open_jdk": 
            case "BUILD_OF_OPEN_JDK": {
                return BUILD_OF_OPEN_JDK;
            }
        }
        return NOT_FOUND;
    }

    public static List<Scope> getAsList() {
        return Arrays.asList(Scope.values());
    }
}

