/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.charset.Charset;
import org.netbeans.modules.netserver.websocket.AbstractWSHandler75;
import org.netbeans.modules.netserver.websocket.Utils;
import org.netbeans.modules.netserver.websocket.WebSocketClientImpl;

class WebSocketHandlerClient75
extends AbstractWSHandler75<WebSocketClientImpl> {
    private boolean handshakeRed;

    WebSocketHandlerClient75(WebSocketClientImpl webSocketClient) {
        super(webSocketClient);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws IOException {
        if (this.handshakeRed) {
            super.read(byteBuffer);
        } else {
            this.readHandshakeResponse(byteBuffer);
            this.handshakeRed = true;
            ((WebSocketClientImpl)this.getWebSocketPoint()).getWebSocketReadHandler().accepted(this.getKey());
        }
    }

    @Override
    public void sendHandshake() {
        StringBuilder builder = new StringBuilder("GET");
        builder.append(' ');
        builder.append(((WebSocketClientImpl)this.getWebSocketPoint()).getUri().getPath());
        builder.append(' ');
        builder.append("HTTP/1.1");
        builder.append("\r\n");
        builder.append("Upgrade: WebSocket");
        builder.append("\r\n");
        builder.append("Host");
        builder.append(": ");
        builder.append(((WebSocketClientImpl)this.getWebSocketPoint()).getUri().getHost());
        builder.append("\r\n");
        builder.append("Origin: ");
        builder.append(Utils.getOrigin(((WebSocketClientImpl)this.getWebSocketPoint()).getUri()));
        builder.append("\r\n");
        builder.append("WebSocket-Protocol");
        builder.append(": chat");
        builder.append("\r\n");
        builder.append("\r\n");
        ((WebSocketClientImpl)this.getWebSocketPoint()).send(builder.toString().getBytes(Charset.forName("UTF-8")), this.getKey());
    }

    protected void readHandshakeResponse(ByteBuffer buffer) throws IOException {
        Utils.readHttpRequest(((WebSocketClientImpl)this.getWebSocketPoint()).getChannel(), buffer);
    }

    @Override
    protected SelectionKey getKey() {
        return ((WebSocketClientImpl)this.getWebSocketPoint()).getKey();
    }

    @Override
    protected void readDelegate(byte[] bytes) {
        ((WebSocketClientImpl)this.getWebSocketPoint()).getWebSocketReadHandler().read(this.getKey(), bytes, null);
    }
}

