/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.TagLibUIManager;
import org.netbeans.modules.web.wizards.targetpanel.providers.WebTargetPanelProvider;
import org.openide.util.NbBundle;

public class TagLibTargetPanelProvider
extends WebTargetPanelProvider<FileType> {
    static final String TAG_LIBRARY = "tag_library";
    public static final String URI = "uri";
    public static final String PREFIX = "prefix";
    private TagLibUIManager myUIManager = new TagLibUIManager();

    @Override
    public void init(TargetChooserPanel<FileType> panel) {
        super.init(panel);
    }

    @Override
    public String getNewFileName() {
        return super.getNewFileName() + TAG_LIBRARY;
    }

    public String getWizardTitle() {
        return NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"TITLE_TLD");
    }

    @Override
    public boolean isValid(TargetChooserPanel<FileType> panel) {
        if (!panel.checkValid()) {
            return false;
        }
        String tldName = panel.getComponent().getTargetName();
        if (tldName.indexOf(32) >= 0 || tldName.indexOf(44) >= 0) {
            panel.getTemplateWizard().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagLibTargetPanelProvider.class, (String)"TXT_wrongTagLibName", (Object)tldName));
            return false;
        }
        return true;
    }

    public TagLibUIManager getUIManager() {
        return this.myUIManager;
    }

    public boolean isApplicable(FileType id) {
        return id == FileType.TAGLIBRARY;
    }

    @Override
    public void storeSettings(TargetChooserPanel<FileType> panel) {
        panel.getTemplateWizard().putProperty(URI, (Object)this.getUIManager().getUri());
        panel.getTemplateWizard().putProperty(PREFIX, (Object)this.getUIManager().getPrefix());
    }

    @Override
    protected WebModule getWebModule() {
        return this.myUIManager.getWebModule();
    }
}

