/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.laf.flatlaf.HiDPIUtils;
import org.netbeans.swing.laf.flatlaf.ui.FlatTabControlIcon;
import org.netbeans.swing.laf.flatlaf.ui.Utils;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public class FlatViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int ICON_X_PAD = 4;
    private static boolean colorsReady = false;
    private static Color background;
    private static Color activeBackground;
    private static Color selectedBackground;
    private static Color hoverBackground;
    private static Color attentionBackground;
    private static Color foreground;
    private static Color activeForeground;
    private static Color selectedForeground;
    private static Color hoverForeground;
    private static Color attentionForeground;
    private static Color underlineColor;
    private static Color inactiveUnderlineColor;
    private static Color tabSeparatorColor;
    private static Color contentBorderColor;
    private static Insets tabInsets;
    private static int underlineHeight;
    private static boolean underlineAtTop;
    private static boolean showTabSeparators;
    private Font font;

    public FlatViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new FlatViewTabDisplayerUI((TabDisplayer)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        FlatViewTabDisplayerUI.initColors();
        this.getLayoutModel().setPadding(new Dimension(FlatViewTabDisplayerUI.tabInsets.left + FlatViewTabDisplayerUI.tabInsets.right, 0));
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm.getHeight() + FlatViewTabDisplayerUI.tabInsets.top + FlatViewTabDisplayerUI.tabInsets.bottom;
        return new Dimension(100, height);
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        int realTxtWidth;
        Component buttons;
        int txtLeftPad = FlatViewTabDisplayerUI.tabInsets.left;
        int txtRightPad = FlatViewTabDisplayerUI.tabInsets.right;
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        int availTxtWidth = width - (txtLeftPad + txtRightPad);
        if (this.isSelected(index) && null != (buttons = this.getControlButtons())) {
            Dimension buttonsSize = buttons.getPreferredSize();
            if (width < buttonsSize.width + 4) {
                buttons.setVisible(false);
            } else {
                buttons.setVisible(true);
                availTxtWidth -= buttonsSize.width + 4;
                buttons.setLocation(x + width - buttonsSize.width - 4, y + (height - buttonsSize.height) / 2 - 1);
            }
        }
        if (this.isTabBusy(index)) {
            Icon busyIcon = BusyTabsSupport.getDefault().getBusyIcon(this.isSelected(index));
            availTxtWidth -= busyIcon.getIconWidth() - UIScale.scale((int)3) - txtLeftPad;
            busyIcon.paintIcon((Component)this.displayer, g, x + txtLeftPad, y + (height - busyIcon.getIconHeight()) / 2);
            int busyWidth = busyIcon.getIconWidth() + UIScale.scale((int)3);
            x += busyWidth;
            width -= busyWidth;
        }
        int n = realTxtWidth = text.startsWith("<html") || text.startsWith("<HTML") ? (int)HtmlRenderer.renderString((String)text, (Graphics)g, (int)0, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)this.getTxtFont(), (Color)foreground, (int)1, (boolean)false) : fm.stringWidth(text);
        if (realTxtWidth > availTxtWidth) {
            int minWidth;
            int left = Math.min(txtLeftPad - 1, realTxtWidth - availTxtWidth);
            txtLeftPad -= left;
            if (realTxtWidth > (availTxtWidth += left + txtRightPad) && text.length() > 3 && (minWidth = fm.stringWidth(text.substring(0, 3) + "\u2026")) > availTxtWidth) {
                for (int i = 2; i >= 0 && fm.stringWidth(text = text.substring(0, i) + "\u2026") >= availTxtWidth; --i) {
                }
            }
        }
        Color c = this.colorForState(index, foreground, activeForeground, selectedForeground, hoverForeground, attentionForeground);
        int txtX = x + txtLeftPad;
        int txtY = y + FlatViewTabDisplayerUI.tabInsets.top + fm.getAscent();
        int availH = height - FlatViewTabDisplayerUI.tabInsets.top - FlatViewTabDisplayerUI.tabInsets.bottom;
        if (availH > fm.getHeight()) {
            txtY += (availH - fm.getHeight()) / 2;
        }
        int style = 1;
        if (!this.isSelected(index)) {
            txtX = Math.max(x + 1, x + (width - realTxtWidth) / 2);
        }
        HtmlRenderer.renderString((String)text, (Graphics)g, (int)txtX, (int)txtY, (int)availTxtWidth, (int)height, (Font)this.getTxtFont(), (Color)c, (int)style, (boolean)true);
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        HiDPIUtils.paintAtScale1x(g, x, y, width, height, (g1x, width1x, height1x, scale) -> this.paintTabBackgroundAtScale1x(g1x, index, width1x, height1x, scale));
    }

    private void paintTabBackgroundAtScale1x(Graphics2D g, int index, int width, int height, double scale) {
        int tabSeparatorWidth = showTabSeparators && index >= 0 ? (int)(1.0 * scale) : 0;
        Color bg = this.colorForState(index, background, activeBackground, selectedBackground, hoverBackground, attentionBackground);
        g.setColor(bg);
        g.fillRect(0, 0, width - (bg != background ? tabSeparatorWidth : 0), height);
        if (this.isSelected(index) && underlineHeight > 0) {
            int underlineHeight = (int)Math.round((double)FlatViewTabDisplayerUI.underlineHeight * scale);
            g.setColor(this.isActive() ? underlineColor : inactiveUnderlineColor);
            if (underlineAtTop) {
                g.fillRect(0, 0, width - tabSeparatorWidth, underlineHeight);
            } else {
                g.fillRect(0, height - underlineHeight, width - tabSeparatorWidth, underlineHeight);
            }
        } else {
            int contentBorderWidth = HiDPIUtils.deviceBorderWidth(scale, 1);
            g.setColor(contentBorderColor);
            g.fillRect(0, height - contentBorderWidth, width, contentBorderWidth);
        }
        if (showTabSeparators && index >= 0) {
            int offset = (int)(4.0 * scale);
            g.setColor(tabSeparatorColor);
            g.fillRect(width - tabSeparatorWidth, offset, tabSeparatorWidth, height - offset * 2 - 1);
        }
    }

    protected void paintDisplayerBackground(Graphics g, JComponent c) {
        this.paintTabBackground(g, -1, 0, 0, c.getWidth(), c.getHeight());
        super.paintDisplayerBackground(g, c);
    }

    private Color colorForState(int index, Color normal, Color active, Color selected, Color hover, Color attention) {
        return this.isAttention(index) ? attention : (this.isMouseOver(index) ? hover : (this.isActive() ? (this.isSelected(index) ? selected : active) : normal));
    }

    protected Font getTxtFont() {
        if (this.font == null) {
            this.font = UIManager.getFont("ViewTab.font");
            if (this.font == null) {
                this.font = UIManager.getFont("Label.font");
            }
        }
        return this.font;
    }

    boolean isMouseOver(int index) {
        if (index < 0) {
            return false;
        }
        return ((OwnController)this.getController()).getMouseIndex() == index;
    }

    private static void initColors() {
        if (!colorsReady) {
            background = UIManager.getColor("ViewTab.background");
            activeBackground = Utils.getUIColor("ViewTab.activeBackground", background);
            selectedBackground = Utils.getUIColor("ViewTab.selectedBackground", activeBackground);
            hoverBackground = UIManager.getColor("ViewTab.hoverBackground");
            attentionBackground = UIManager.getColor("ViewTab.attentionBackground");
            foreground = Utils.getUIColor("ViewTab.foreground", "TabbedPane.foreground");
            activeForeground = Utils.getUIColor("ViewTab.activeForeground", foreground);
            selectedForeground = Utils.getUIColor("ViewTab.selectedForeground", activeForeground);
            hoverForeground = Utils.getUIColor("ViewTab.hoverForeground", foreground);
            attentionForeground = Utils.getUIColor("ViewTab.attentionForeground", foreground);
            underlineColor = UIManager.getColor("ViewTab.underlineColor");
            inactiveUnderlineColor = UIManager.getColor("ViewTab.inactiveUnderlineColor");
            tabSeparatorColor = UIManager.getColor("ViewTab.tabSeparatorColor");
            contentBorderColor = UIManager.getColor("TabbedContainer.view.contentBorderColor");
            tabInsets = UIManager.getInsets("ViewTab.tabInsets");
            underlineHeight = UIManager.getInt("ViewTab.underlineHeight");
            underlineAtTop = UIManager.getBoolean("ViewTab.underlineAtTop");
            showTabSeparators = UIManager.getBoolean("ViewTab.showTabSeparators");
            tabInsets = UIScale.scale((Insets)tabInsets);
            underlineHeight = UIScale.scale((int)underlineHeight);
            colorsReady = true;
        }
    }

    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon ret = FlatTabControlIcon.get(buttonId, buttonState);
        return ret != null ? ret : super.getButtonIcon(buttonId, buttonState);
    }

    public void postTabAction(TabActionEvent e) {
        super.postTabAction(e);
        if ("maximize".equals(e.getActionCommand())) {
            ((OwnController)this.getController()).updateHighlight(-1);
        }
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex;

        private OwnController() {
            super((AbstractViewTabDisplayerUI)FlatViewTabDisplayerUI.this);
            this.lastIndex = -1;
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            Point pos = e.getPoint();
            this.updateHighlight(FlatViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(pos.x, pos.y));
        }

        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            if (!this.inControlButtonsRect(e.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int curIndex) {
            int h;
            int w;
            int y;
            int x;
            if (curIndex == this.lastIndex) {
                return;
            }
            TabLayoutModel tlm = FlatViewTabDisplayerUI.this.getLayoutModel();
            Rectangle repaintRect = null;
            if (curIndex != -1) {
                x = tlm.getX(curIndex) - 1;
                y = tlm.getY(curIndex);
                w = tlm.getW(curIndex) + 2;
                h = tlm.getH(curIndex);
                repaintRect = new Rectangle(x, y, w, h);
            }
            if (this.lastIndex != -1 && this.lastIndex < FlatViewTabDisplayerUI.this.getDataModel().size()) {
                x = tlm.getX(this.lastIndex) - 1;
                y = tlm.getY(this.lastIndex);
                w = tlm.getW(this.lastIndex) + 2;
                h = tlm.getH(this.lastIndex);
                repaintRect = repaintRect != null ? repaintRect.union(new Rectangle(x, y, w, h)) : new Rectangle(x, y, w, h);
            }
            if (repaintRect != null) {
                FlatViewTabDisplayerUI.this.getDisplayer().repaint(repaintRect);
            }
            this.lastIndex = curIndex;
        }
    }
}

