/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.MergeColumnDialog;

public class MergeColumnCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(MergeColumnCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MergeColumnCommand.class);
    protected MergeColumnDialog customDialog;

    public MergeColumnCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return;
        }
        this.showCustomDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        ArrayList<String> results;
        block16: {
            results = new ArrayList<String>();
            ArrayList<String> updateResults = new ArrayList<String>();
            ISQLDatabaseMetaData md = this._session.getMetaData();
            String joinString = this.customDialog.getJoinString();
            String column1 = this.customDialog.getFirstColumn();
            String column2 = this.customDialog.getSecondColumn();
            String catalog = this._info[0].getCatalogName();
            String schema = this._info[0].getSchemaName();
            DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(catalog, schema);
            String table = this._info[0].getSimpleName();
            ArrayList<String[]> data = new ArrayList<String[]>();
            String mergeInColumn = "";
            int typeLength = 0;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                String dataQuery = "SELECT  \"" + column1 + "\", \"" + column2 + "\" FROM \"" + schema + "\".\"" + table + "\"";
                stmt = this._session.getSQLConnection().createStatement();
                rs = stmt.executeQuery(dataQuery);
                while (rs.next()) {
                    data.add(new String[]{rs.getString(1), rs.getString(2)});
                }
                if (this.customDialog.isNewColumn()) {
                    mergeInColumn = this.customDialog.getNewColumnName();
                } else if (this.customDialog.isMergeInExistingColumn()) {
                    mergeInColumn = this.customDialog.getMergeInExistingColumn();
                }
                for (String[] dataColumn : data) {
                    String mergeColumnData;
                    StringBuilder mergeColumnBuilder = new StringBuilder();
                    if (dataColumn[0] == null && dataColumn[1] == null && joinString.equals("")) {
                        mergeColumnData = null;
                        typeLength = 1;
                    } else {
                        mergeColumnBuilder.append("'");
                        mergeColumnBuilder.append(dataColumn[0] == null ? "" : dataColumn[0]);
                        mergeColumnBuilder.append(joinString);
                        mergeColumnBuilder.append(dataColumn[1] == null ? "" : dataColumn[1]);
                        mergeColumnBuilder.append("'");
                        mergeColumnData = mergeColumnBuilder.toString();
                        if (typeLength < mergeColumnBuilder.length() - 2) {
                            typeLength = mergeColumnBuilder.length() - 2;
                        }
                        if (dataColumn[0] != null) {
                            dataColumn[0] = "'" + dataColumn[0] + "'";
                        }
                        if (dataColumn[1] != null) {
                            dataColumn[1] = "'" + dataColumn[1] + "'";
                        }
                    }
                    updateResults.addAll(Arrays.asList(this._dialect.getUpdateSQL(table, new String[]{mergeInColumn}, new String[]{mergeColumnData}, null, new String[]{column1, column2}, new String[]{dataColumn[0], dataColumn[1]}, qualifier, this._sqlPrefs)));
                }
                if (this.customDialog.isNewColumn()) {
                    TableColumnInfo newColumn = new TableColumnInfo(catalog, schema, table, mergeInColumn, 12, JDBCTypeMapper.getJdbcTypeName((int)12), typeLength, 0, 0, 1, null, null, 0, 1, "YES", md);
                    results.addAll(Arrays.asList(this._dialect.getAddColumnSQL(newColumn, qualifier, this._sqlPrefs)));
                }
                results.addAll(updateResults);
                SQLUtilities.closeResultSet((ResultSet)rs);
            }
            catch (SQLException e) {
                s_log.error((Object)("generateSQLStatements: unexpected exception: " + e.getMessage()), (Throwable)e);
                this._session.showErrorMessage((Throwable)e);
                break block16;
            }
            finally {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement(stmt);
            }
            SQLUtilities.closeStatement((Statement)stmt);
        }
        return results.toArray(new String[0]);
    }

    @Override
    protected void executeScript(String script) {
        AbstractRefactoringCommand.CommandExecHandler handler = new AbstractRefactoringCommand.CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MergeColumnCommand.this.customDialog.setVisible(false);
                        MergeColumnCommand.this.customDialog.dispose();
                        MergeColumnCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialect) {
        boolean result = true;
        result = result && dialect.supportsUpdate();
        result = result && dialect.supportsAddColumn();
        return result;
    }

    private void showCustomDialog() throws SQLException {
        ITableInfo selectedTable = (ITableInfo)this._info[0];
        TableColumnInfo[] tableColumnInfos = this._session.getMetaData().getColumnInfo(selectedTable);
        TreeSet<String> localColumns = new TreeSet<String>();
        for (TableColumnInfo columns : tableColumnInfos) {
            localColumns.add(columns.getColumnName());
        }
        this.customDialog = new MergeColumnDialog(selectedTable.getSimpleName(), localColumns.toArray(new String[0]));
        this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(this.customDialog));
        this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, this.customDialog));
        this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setVisible(true);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = MergeColumnCommand.access$000().getString("MergeColumnCommand.sqlDialogTitle");
    }
}

