/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import net.sf.tinylaf.MenuItemIconFactory;
import net.sf.tinylaf.SpecialUIButton;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import net.sf.tinylaf.TinyMenuUI;
import net.sf.tinylaf.TinyPopupFactory;
import net.sf.tinylaf.TinyRootPaneUI;
import net.sf.tinylaf.TinyWindowButtonUI;
import net.sf.tinylaf.controlpanel.ControlPanel;
import net.sf.tinylaf.util.ColorRoutines;

public class TinyTitlePane
extends JComponent {
    private static final HashMap cache = new HashMap();
    public static Color buttonUpperColor;
    public static Color buttonLowerColor;
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private static TinyWindowButtonUI iconButtonUI;
    private static TinyWindowButtonUI maxButtonUI;
    private static TinyWindowButtonUI closeButtonUI;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Image systemIcon;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private WindowListener windowListener;
    private ComponentListener windowMoveListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private TinyRootPaneUI rootPaneUI;

    public TinyTitlePane(JRootPane root, TinyRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    public static void clearCache() {
        cache.clear();
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
            this.windowMoveListener = new WindowMoveListener();
            this.window.addComponentListener(this.windowMoveListener);
            if (this.window instanceof JDialog) {
                TinyPopupFactory.addDialog((JDialog)this.window);
            }
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.window.removeComponentListener(this.windowMoveListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
            this.updateSystemIcon();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons(decorationStyle);
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
            this.iconifyButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.toggleButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.TRUE);
        } else if (decorationStyle == 2 || decorationStyle == 5 || decorationStyle == 6) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons(decorationStyle);
            this.add(this.closeButton);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.TRUE);
        } else if (decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons(decorationStyle);
            this.add(this.closeButton);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.TRUE);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("Frame.titleFont", this.getLocale()));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void updateSystemIcon() {
        this.systemIcon = this.getWindowIcon(this.getWindow());
    }

    private Image getWindowIcon(Window window) {
        if (window == null) {
            return null;
        }
        if (window instanceof Frame) {
            return ((Frame)window).getIconImage();
        }
        try {
            Method getIconImages = window.getClass().getMethod("getIconImages", null);
            List icons = (List)getIconImages.invoke((Object)window, (Object[])null);
            if (icons != null) {
                if (icons.size() == 0) {
                    return this.getWindowIcon(window.getOwner());
                }
                if (icons.size() == 1) {
                    return (Image)icons.get(0);
                }
                for (int i = 0; i < icons.size(); ++i) {
                    Image img = (Image)icons.get(i);
                    if (img.getWidth(this) != 16 || img.getHeight(this) != 16) continue;
                    return img;
                }
                return ((Image)icons.get(0)).getScaledInstance(16, 16, 4);
            }
        }
        catch (Exception ex) {
            return this.getWindowIcon(window.getOwner());
        }
        return null;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(frame.getExtendedState() | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            this.setMaximizeBounds(frame);
            frame.setExtendedState(frame.getExtendedState() | 6);
        }
    }

    protected void setMaximizeBounds(Frame frame) {
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = screenSize.width - screenInsets.left - screenInsets.right;
        int h = screenSize.height - screenInsets.top - screenInsets.bottom;
        Rectangle maxBounds = new Rectangle(screenInsets.left, screenInsets.top, w, h);
        frame.setMaximizedBounds(maxBounds);
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((frame.getExtendedState() & 1) == 1) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                if (TinyTitlePane.this.windowHasMenuBar()) {
                    TinyMenuUI.systemMenuShowing = true;
                }
            }

            public void menuDeselected(MenuEvent e) {
                TinyMenuUI.systemMenuShowing = false;
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        if (this.getWindowDecorationStyle() == 1) {
            this.addSystemMenuItems(menu, true);
            menu.putClientProperty("isSystemMenu", Boolean.TRUE);
        } else if (this.getWindowDecorationStyle() != 0) {
            this.addSystemMenuItems(menu, false);
            menu.putClientProperty("isSystemMenu", Boolean.TRUE);
        }
        return menu;
    }

    private boolean windowHasMenuBar() {
        Window w = this.getWindow();
        if (w instanceof JFrame) {
            return ((JFrame)w).getJMenuBar() != null;
        }
        if (w instanceof JDialog) {
            return ((JDialog)w).getJMenuBar() != null;
        }
        return false;
    }

    private void addSystemMenuItems(JMenu menu, boolean isFrame) {
        int mnemonic;
        Locale locale = this.getRootPane().getLocale();
        JMenuItem item = null;
        if (isFrame) {
            item = menu.add(this.restoreAction);
            item.setIcon(MenuItemIconFactory.getSystemRestoreIcon());
            mnemonic = this.getInt("MetalTitlePane.restoreMnemonic", -1);
            if (mnemonic != -1) {
                item.setMnemonic(mnemonic);
            }
            item = menu.add(this.iconifyAction);
            item.setIcon(MenuItemIconFactory.getSystemIconifyIcon());
            mnemonic = this.getInt("MetalTitlePane.iconifyMnemonic", -1);
            if (mnemonic != -1) {
                item.setMnemonic(mnemonic);
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                item = menu.add(this.maximizeAction);
                item.setIcon(MenuItemIconFactory.getSystemMaximizeIcon());
                mnemonic = this.getInt("MetalTitlePane.maximizeMnemonic", -1);
                if (mnemonic != -1) {
                    item.setMnemonic(mnemonic);
                }
            }
            menu.addSeparator();
        }
        item = menu.add(this.closeAction);
        item.setIcon(MenuItemIconFactory.getSystemCloseIcon());
        mnemonic = this.getInt("MetalTitlePane.closeMnemonic", -1);
        if (mnemonic != -1) {
            item.setMnemonic(mnemonic);
        }
    }

    protected void createButtons(int decorationStyle) {
        if (iconButtonUI == null) {
            iconButtonUI = TinyWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = TinyWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = TinyWindowButtonUI.createButtonUIForType(0);
        }
        this.iconifyButton = new SpecialUIButton(iconButtonUI);
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setText(null);
        this.iconifyButton.setRolloverEnabled(true);
        this.toggleButton = new SpecialUIButton(maxButtonUI);
        this.toggleButton.setAction(this.maximizeAction);
        this.toggleButton.setText(null);
        this.toggleButton.setRolloverEnabled(true);
        this.closeButton = new SpecialUIButton(closeButtonUI);
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
        if (TinyLookAndFeel.controlPanelInstantiated && decorationStyle == 1) {
            ControlPanel.setWindowButtons(new JButton[]{this.iconifyButton, this.toggleButton, this.closeButton});
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.closeButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
            this.iconifyButton.setEnabled(isActive);
            this.closeButton.setEnabled(isActive);
            this.toggleButton.setEnabled(isActive);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) == 6 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing() || (state & 6) != 6) {
                    // empty if block
                }
                if (frame.isResizable()) {
                    if ((state & 4) == 4 || (state & 2) == 2) {
                        this.updateToggleButton(this.restoreAction);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action) {
        this.toggleButton.setAction(action);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    public boolean isSelected() {
        Window window = this.getWindow();
        return window == null ? true : window.isActive();
    }

    public boolean isFrameMaximized() {
        Frame frame = this.getFrame();
        if (frame != null) {
            return (frame.getExtendedState() & 6) == 6;
        }
        return false;
    }

    public void paintComponent(Graphics g) {
        String theTitle;
        Window window;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        boolean leftToRight = (window = this.getWindow()) == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean isActive = window == null ? true : window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        int xOffset = leftToRight ? 5 : width - 5;
        this.paintCaption(g, width, height, isActive, 29, window);
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1 || decorationStyle == 2 || decorationStyle == 5 || decorationStyle == 6) {
            xOffset += leftToRight ? 21 : -21;
        }
        if ((theTitle = this.getTitle()) != null) {
            FontMetrics fm = g.getFontMetrics();
            int yd = height == 29 ? 2 : 0;
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent() + yd;
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rect = this.iconifyButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = window.getWidth() - window.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                theTitle = this.clippedText(theTitle, fm, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                theTitle = this.clippedText(theTitle, fm, titleW);
                xOffset -= SwingUtilities.computeStringWidth(fm, theTitle);
            }
            int titleLength = SwingUtilities.computeStringWidth(fm, theTitle);
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (isActive) {
                g.setColor(Theme.frameTitleShadowColor.getColor());
                g.drawString(theTitle, xOffset + 1, yOffset + 1);
                g.setColor(Theme.frameTitleColor.getColor());
                g.drawString(theTitle, xOffset, yOffset);
            } else {
                g.setColor(Theme.frameTitleDisabledColor.getColor());
                g.drawString(theTitle, xOffset, yOffset);
            }
        }
    }

    private void paintCaption(Graphics g, int w, int h, boolean isActive, int titleHeight, Window window) {
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.paintXPCaptionNoCache(g, w, h, isActive, titleHeight, window);
        } else {
            this.paintXPCaption(g, w, h, isActive, titleHeight, window);
        }
    }

    private void paintXPCaption(Graphics g, int w, int h, boolean isActive, int titleHeight, Window window) {
        ColorUIResource c = null;
        c = isActive ? Theme.frameCaptionColor.getColor() : Theme.frameCaptionDisabledColor.getColor();
        g.setColor(c);
        int x = 0;
        int y = 0;
        int spread1 = Theme.frameSpreadDarkDisabled.getValue();
        int spread2 = Theme.frameSpreadLightDisabled.getValue();
        int y2 = y;
        ColorUIResource borderColor = null;
        if (isActive) {
            borderColor = Theme.frameBorderColor.getColor();
            spread1 = Theme.frameSpreadDark.getValue();
            spread2 = Theme.frameSpreadLight.getValue();
        } else {
            borderColor = Theme.frameBorderDisabledColor.getColor();
        }
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x, y2, x, y2);
        g.drawLine(x + w - 1, y2, x + w - 1, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 1, y2);
        g.setColor(c);
        g.drawLine(x, y2, x, y2);
        g.drawLine(x + w - 1, y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x, ++y2, x, y2);
        g.drawLine(x + w - 1, y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 2, ++y2, x + 2, y2);
        g.drawLine(x + x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x, y2, x, y2);
        g.drawLine(x + w - 1, y2, x + w - 1, y2);
        g.setColor(c);
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        ++y2;
        CaptionKey key = new CaptionKey(Theme.frameCaptionColor.getColor(), isActive, titleHeight);
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, x + 3, y, x + w - 3, y + 5, 0, 0, 1, 5, window);
            g.drawImage((Image)value, x, y + 5, x + w, y + titleHeight, 0, 5, 1, titleHeight, window);
            buttonUpperColor = ColorRoutines.darken(c, 4 * spread1);
            buttonLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            return;
        }
        BufferedImage img = new BufferedImage(1, titleHeight, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(borderColor);
        imgGraphics.drawLine(0, 0, 1, 0);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 1, 1, 1);
        imgGraphics.setColor(ColorRoutines.lighten(c, 10 * spread2));
        imgGraphics.drawLine(0, 2, 1, 2);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 3, 1, 3);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 4, 1, 4);
        buttonUpperColor = ColorRoutines.darken(c, 4 * spread1);
        imgGraphics.setColor(buttonUpperColor);
        imgGraphics.drawLine(0, 5, 1, 5);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 6, 1, 6);
        imgGraphics.drawLine(0, 7, 1, 7);
        imgGraphics.setColor(ColorRoutines.darken(c, 3 * spread1));
        imgGraphics.drawLine(0, 8, 1, 8);
        imgGraphics.drawLine(0, 9, 1, 9);
        imgGraphics.drawLine(0, 10, 1, 10);
        imgGraphics.drawLine(0, 11, 1, 11);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 12, 1, 12);
        imgGraphics.drawLine(0, 13, 1, 13);
        imgGraphics.drawLine(0, 14, 1, 14);
        imgGraphics.setColor(ColorRoutines.darken(c, spread1));
        imgGraphics.drawLine(0, 15, 1, 15);
        imgGraphics.drawLine(0, 16, 1, 16);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 17, 1, 17);
        imgGraphics.drawLine(0, 18, 1, 18);
        imgGraphics.setColor(ColorRoutines.lighten(c, 2 * spread2));
        imgGraphics.drawLine(0, 19, 1, 19);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 20, 1, 20);
        imgGraphics.setColor(ColorRoutines.lighten(c, 5 * spread2));
        imgGraphics.drawLine(0, 21, 1, 21);
        imgGraphics.setColor(ColorRoutines.lighten(c, 6 * spread2));
        imgGraphics.drawLine(0, 22, 1, 22);
        imgGraphics.setColor(ColorRoutines.lighten(c, 8 * spread2));
        imgGraphics.drawLine(0, 23, 1, 23);
        imgGraphics.setColor(ColorRoutines.lighten(c, 9 * spread2));
        imgGraphics.drawLine(0, 24, 1, 24);
        buttonLowerColor = ColorRoutines.lighten(c, 10 * spread2);
        imgGraphics.setColor(buttonLowerColor);
        imgGraphics.drawLine(0, 25, 1, 25);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 26, 1, 26);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 27, 1, 27);
        if (isActive) {
            imgGraphics.setColor(Theme.frameLightColor.getColor());
        } else {
            imgGraphics.setColor(Theme.frameLightDisabledColor.getColor());
        }
        imgGraphics.drawLine(0, 28, 1, 28);
        imgGraphics.dispose();
        g.drawImage(img, x + 3, y, x + w - 3, y + 5, 0, 0, 1, 5, window);
        g.drawImage(img, x, y + 5, x + w, y + titleHeight, 0, 5, 1, titleHeight, window);
        cache.put(key, img);
    }

    private void paintXPCaptionNoCache(Graphics g, int w, int h, boolean isActive, int titleHeight, Window window) {
        ColorUIResource c = null;
        c = isActive ? Theme.frameCaptionColor.getColor() : Theme.frameCaptionDisabledColor.getColor();
        g.setColor(c);
        int x = 0;
        int y = 0;
        int spread1 = Theme.frameSpreadDarkDisabled.getValue();
        int spread2 = Theme.frameSpreadLightDisabled.getValue();
        int y2 = y;
        ColorUIResource borderColor = null;
        if (isActive) {
            borderColor = Theme.frameBorderColor.getColor();
            spread1 = Theme.frameSpreadDark.getValue();
            spread2 = Theme.frameSpreadLight.getValue();
        } else {
            borderColor = Theme.frameBorderDisabledColor.getColor();
        }
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x, y2, x, y2);
        g.drawLine(x + w - 1, y2, x + w - 1, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 1, y2);
        g.setColor(c);
        g.drawLine(x, y2, x, y2);
        g.drawLine(x + w - 1, y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x, ++y2, x, y2);
        g.drawLine(x + w - 1, y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 2, ++y2, x + 2, y2);
        g.drawLine(x + x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x, y2, x, y2);
        g.drawLine(x + w - 1, y2, x + w - 1, y2);
        g.setColor(c);
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        y2 = y;
        g.setColor(borderColor);
        g.drawLine(x + 3, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        buttonUpperColor = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(buttonUpperColor);
        g.drawLine(x, ++y2, x + w - 1, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.fillRect(x, ++y2, x + w, 2);
        g.setColor(ColorRoutines.darken(c, 3 * spread1));
        g.fillRect(x, y2 += 2, x + w, 4);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.fillRect(x, y2 += 4, x + w, 3);
        g.setColor(ColorRoutines.darken(c, 1 * spread1));
        g.fillRect(x, y2 += 3, x + w, 2);
        g.setColor(c);
        g.fillRect(x, y2 += 2, x + w, 2);
        g.setColor(ColorRoutines.lighten(c, 2 * spread2));
        g.drawLine(x, y2 += 2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x, ++y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x, ++y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 6 * spread2));
        g.drawLine(x, ++y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 8 * spread2));
        g.drawLine(x, ++y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 9 * spread2));
        g.drawLine(x, ++y2, x + w - 1, y2);
        buttonLowerColor = ColorRoutines.lighten(c, 10 * spread2);
        g.setColor(buttonLowerColor);
        g.drawLine(x, ++y2, x + w - 1, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x, ++y2, x + w - 1, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x, ++y2, x + w - 1, y2);
        ++y2;
        if (isActive) {
            g.setColor(Theme.frameLightColor.getColor());
        } else {
            g.setColor(Theme.frameLightDisabledColor.getColor());
        }
        g.drawLine(x, y2, x + w - 1, y2);
    }

    private String clippedText(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || text.equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, text);
        String clipString = "...";
        if (textWidth > availTextWidth) {
            int nChars;
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            for (nChars = 0; nChars < text.length() && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
            }
            text = text.substring(0, nChars) + clipString;
        }
        return text;
    }

    private int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static class CaptionKey {
        private Color frameCaptionColor;
        private boolean isActive;
        private int titleHeight;

        CaptionKey(Color frameCaptionColor, boolean isActive, int titleHeight) {
            this.frameCaptionColor = frameCaptionColor;
            this.isActive = isActive;
            this.titleHeight = titleHeight;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof CaptionKey)) {
                return false;
            }
            CaptionKey other = (CaptionKey)o;
            return this.frameCaptionColor.equals(other.frameCaptionColor) && this.isActive == other.isActive && this.titleHeight == other.titleHeight;
        }

        public int hashCode() {
            return this.frameCaptionColor.hashCode() * (this.isActive ? 1 : 2) * this.titleHeight;
        }
    }

    class WindowMoveListener
    extends ComponentAdapter {
        WindowMoveListener() {
        }

        public void componentMoved(ComponentEvent e) {
            if (TinyTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = TinyTitlePane.this.getWindow();
            if (!w.isShowing()) {
                return;
            }
            w.repaint(0, 0, w.getWidth(), 5);
        }

        public void componentResized(ComponentEvent e) {
            if (TinyTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = TinyTitlePane.this.getWindow();
            if (!w.isShowing()) {
                return;
            }
            w.repaint(0, 0, w.getWidth(), 5);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            TinyTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            TinyTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = TinyTitlePane.this.getFrame();
                if (frame != null) {
                    TinyTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    TinyTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                TinyTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                TinyTitlePane.this.revalidate();
                TinyTitlePane.this.repaint();
            } else if ("iconImage".equals(name)) {
                TinyTitlePane.this.updateSystemIcon();
                TinyTitlePane.this.revalidate();
                TinyTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(104, this.computeHeight());
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            Window window = TinyTitlePane.this.getWindow();
            if (window instanceof Frame) {
                TinyTitlePane.this.setMaximizeBounds(TinyTitlePane.this.getFrame());
                return 29;
            }
            if (window instanceof Dialog) {
                return 29;
            }
            return 25;
        }

        public void layoutContainer(Container c) {
            int x;
            int buttonWidth;
            int buttonHeight;
            if (TinyTitlePane.this.getWindowDecorationStyle() == 0) {
                TinyTitlePane.this.buttonsWidth = 0;
                return;
            }
            boolean leftToRight = TinyTitlePane.this.window == null ? TinyTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : TinyTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = TinyTitlePane.this.getWidth();
            if (TinyTitlePane.this.closeButton != null) {
                buttonHeight = ((TinyTitlePane)TinyTitlePane.this).closeButton.getPreferredSize().height;
                buttonWidth = ((TinyTitlePane)TinyTitlePane.this).closeButton.getPreferredSize().width;
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int yd = TinyTitlePane.this.getHeight() == 29 ? 1 : 0;
            int y = (TinyTitlePane.this.getHeight() - buttonHeight) / 2 + yd;
            int spacing = 5;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (TinyTitlePane.this.menuBar != null) {
                TinyTitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = 2;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (TinyTitlePane.this.closeButton != null) {
                TinyTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && TinyTitlePane.this.toggleButton.getParent() != null) {
                TinyTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (TinyTitlePane.this.iconifyButton != null && TinyTitlePane.this.iconifyButton.getParent() != null) {
                TinyTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            TinyTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        public void paint(Graphics g) {
            int height = this.getHeight();
            if (TinyTitlePane.this.systemIcon != null) {
                g.drawImage(TinyTitlePane.this.systemIcon, 0, (height - 16) / 2 + 1, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, (height - icon.getIconHeight()) / 2 + 1);
                }
            }
        }

        private Window getOwningFrame(Dialog dialog) {
            Window w;
            while ((w = dialog.getOwner()) != null) {
                if (!(w instanceof Dialog)) {
                    return w;
                }
                dialog = (Dialog)w;
            }
            return w;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (TinyTitlePane.this.systemIcon != null) {
                return new Dimension(16, 16);
            }
            Icon icon = UIManager.getIcon("InternalFrame.icon");
            if (icon != null) {
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TinyTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TinyTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TinyTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TinyTitlePane.this.close();
        }
    }
}

