/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.io.UnicodeReader;
import org.fife.rtext.RText;
import org.fife.ui.ImageTranscodingUtil;
import org.fife.ui.OS;
import org.fife.ui.rtextarea.IconGroup;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

final class IconGroupLoader
extends DefaultHandler {
    public static final String DEFAULT_ICON_GROUP_NAME = "Eclipse Icons";
    private RText owner;
    private Map<String, IconGroup> iconGroupMap;
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String LARGEICONSUBDIR = "largeIconSubDir";
    private static final String EXTENSION = "extension";
    private static final String JAR = "jar";

    private IconGroupLoader(RText owner) {
        this.owner = owner;
        this.iconGroupMap = new HashMap<String, IconGroup>(3);
    }

    private void addOfficeLnFsIconGroups() {
        String windows98Icons = "Windows 98 Icons";
        String office2003Icons = "Office 2003 Icons";
        IconGroup win98IconGroup = new IconGroup(windows98Icons, "org/fife/plaf/OfficeXP/");
        IconGroup office2003IconGroup = new IconGroup(office2003Icons, "org/fife/plaf/Office2003/");
        this.iconGroupMap.put(win98IconGroup.getName(), win98IconGroup);
        this.iconGroupMap.put(office2003IconGroup.getName(), office2003IconGroup);
    }

    private Map<String, IconGroup> doLoad(String iconGroupFile) {
        try {
            SAXParser parser = SAXParserFactory.newDefaultInstance().newSAXParser();
            InputSource is = new InputSource((Reader)new UnicodeReader((InputStream)new FileInputStream(iconGroupFile), "UTF-8"));
            is.setEncoding("UTF-8");
            parser.parse(is, (DefaultHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.owner.displayException(e);
            return this.iconGroupMap;
        }
        if (this.owner.getOS() == OS.WINDOWS) {
            this.addOfficeLnFsIconGroups();
        }
        SvgIconGroup flatIconGroup = new SvgIconGroup("IntelliJ Icons (Dark)", "icongroups/intellij-icons.jar");
        this.iconGroupMap.put(flatIconGroup.getName(), flatIconGroup);
        return this.iconGroupMap;
    }

    public static Map<String, IconGroup> loadIconGroups(RText rtext, String iconGroupFile) {
        IconGroupLoader loader = new IconGroupLoader(rtext);
        return loader.doLoad(iconGroupFile);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (GROUP.equals(qName)) {
            String name = attributes.getValue(NAME);
            String path = attributes.getValue(PATH);
            if (path == null) {
                path = "";
            }
            String largeIconSubDir = attributes.getValue(LARGEICONSUBDIR);
            String extension = attributes.getValue(EXTENSION);
            Object jar = attributes.getValue(JAR);
            if (jar != null) {
                jar = this.owner.getInstallLocation() + "/" + (String)jar;
            }
            IconGroup group = new IconGroup(name, path, largeIconSubDir, extension, (String)jar);
            this.iconGroupMap.put(name, group);
        }
    }

    private class SvgIconGroup
    extends IconGroup {
        private String jarFile;

        SvgIconGroup(String name, String jarFile) {
            super(name, "", null, "svg", jarFile);
            this.jarFile = IconGroupLoader.this.owner.getInstallLocation() + "/" + jarFile;
        }

        protected Icon getIconImpl(String iconFullPath) {
            ImageIcon imageIcon;
            block8: {
                InputStream svg = new URL("jar:file:///" + this.jarFile + "!/" + iconFullPath).openStream();
                try {
                    BufferedImage image = ImageTranscodingUtil.rasterize((String)iconFullPath, (InputStream)svg, (int)16, (int)16);
                    imageIcon = new ImageIcon(image);
                    if (svg == null) break block8;
                }
                catch (Throwable image) {
                    try {
                        if (svg != null) {
                            try {
                                svg.close();
                            }
                            catch (Throwable throwable) {
                                image.addSuppressed(throwable);
                            }
                        }
                        throw image;
                    }
                    catch (IOException ioe) {
                        int lastDot = iconFullPath.lastIndexOf(46);
                        String pngIconName = iconFullPath.substring(0, lastDot) + ".png";
                        return super.getIconImpl(pngIconName);
                    }
                }
                svg.close();
            }
            return imageIcon;
        }
    }
}

