/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.fife.rtext.RText;
import org.fife.rtext.optionsdialog.FileFilterOptionPanel;
import org.fife.rtext.optionsdialog.GeneralOptionPanel;
import org.fife.rtext.optionsdialog.LanguageOptionPanel;
import org.fife.rtext.optionsdialog.PrintingOptionPanel;
import org.fife.rtext.optionsdialog.SearchOptionPanel;
import org.fife.rtext.optionsdialog.ShortcutOptionPanel;
import org.fife.rtext.optionsdialog.UIOptionPanel;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.Plugin;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaOptionPanel;
import org.fife.ui.rsyntaxtextarea.SpellingOptionPanel;
import org.fife.ui.rsyntaxtextarea.TemplateOptionPanel;
import org.fife.ui.rtextarea.CaretAndSelectionOptionPanel;
import org.fife.ui.rtextarea.GutterOptionPanel;
import org.fife.ui.rtextarea.RTextAreaOptionPanel;
import org.fife.ui.rtextfilechooser.FileChooserFavoritesOptionPanel;
import org.fife.ui.rtextfilechooser.RTextFileChooserOptionPanel;

public class OptionsDialog
extends org.fife.ui.OptionsDialog {
    public OptionsDialog(RText rtext) {
        super((Frame)((Object)rtext));
        Plugin[] plugins;
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.rtext.OptionsDialog");
        ArrayList<OptionsDialogPanel> panels = new ArrayList<OptionsDialogPanel>();
        OptionsDialogPanel panel = new GeneralOptionPanel(rtext, msg);
        this.setIcon(panel, "general.png");
        panels.add(panel);
        panel = new UIOptionPanel(rtext, msg);
        this.setIcon(panel, "ui.png");
        panels.add(panel);
        LanguageOptionPanel panel2 = new LanguageOptionPanel((GUIApplication)rtext, msg);
        this.setIcon(panel2, "language.png");
        panel.addChildPanel(panel2);
        panel = new RTextAreaOptionPanel();
        this.setIcon(panel, "textarea.png");
        panels.add(panel);
        panel.addChildPanel(new RSyntaxTextAreaOptionPanel());
        panel.addChildPanel(new CaretAndSelectionOptionPanel());
        panel.addChildPanel(new GutterOptionPanel());
        panel.addChildPanel(new SpellingOptionPanel());
        panel.addChildPanel(new TemplateOptionPanel());
        panel = new SearchOptionPanel((GUIApplication)rtext, msg);
        this.setIcon(panel, "search.png");
        panels.add(panel);
        panel = new RTextFileChooserOptionPanel();
        this.setIcon(panel, "file_chooser.png");
        panels.add(panel);
        panel.addChildPanel((OptionsDialogPanel)new FileChooserFavoritesOptionPanel());
        panel = new PrintingOptionPanel(rtext, msg);
        panels.add(panel);
        panel = new FileFilterOptionPanel(rtext, msg);
        this.setIcon(panel, "file_filters.png");
        panels.add(panel);
        panel = new ShortcutOptionPanel(rtext, msg);
        this.setIcon(panel, "shortcuts.png");
        panels.add(panel);
        for (Plugin plugin : plugins = rtext.getPlugins()) {
            panel = plugin.getOptionsDialogPanel();
            if (panel == null) continue;
            panel.setIcon(plugin.getPluginIcon());
            String parentID = plugin.getOptionsDialogPanelParentPanelID();
            if (parentID != null) {
                OptionsDialogPanel parent = OptionsDialog.getPanelById(panels, parentID);
                if (parent != null) {
                    parent.addChildPanel(panel);
                    continue;
                }
                panels.add(panel);
                continue;
            }
            panels.add(panel);
        }
        OptionsDialogPanel[] array = new OptionsDialogPanel[panels.size()];
        array = panels.toArray(array);
        this.setOptionsPanels(array);
    }

    private static OptionsDialogPanel getPanelById(List<OptionsDialogPanel> panels, String id) {
        for (OptionsDialogPanel panel : panels) {
            OptionsDialogPanel result = OptionsDialog.getPanelByIdImpl(panel, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static OptionsDialogPanel getPanelByIdImpl(OptionsDialogPanel panel, String id) {
        if (id.equals(panel.getId())) {
            return panel;
        }
        for (int i = 0; i < panel.getChildPanelCount(); ++i) {
            OptionsDialogPanel child = panel.getChildPanel(i);
            OptionsDialogPanel result = OptionsDialog.getPanelByIdImpl(child, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void setIcon(OptionsDialogPanel panel, String iconSuffix) {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        String prefix = "org/fife/rtext/graphics/options_";
        panel.setIcon((Icon)new ImageIcon(cl.getResource(prefix + iconSuffix)));
    }
}

