/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.db2.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.FormattedSourceTab;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.db2.sql.DB2Sql;
import net.sourceforge.squirrel_sql.plugins.db2.tab.ViewSourceTab;

public class TableSourceTab
extends FormattedSourceTab {
    private static final ILogger s_log = LoggerController.createLogger(ViewSourceTab.class);
    private final DB2Sql db2Sql;

    public TableSourceTab(String hint, String stmtSep, DB2Sql db2Sql) {
        super(hint);
        super.setCompressWhitespace(true);
        super.setupFormatter(stmtSep, null);
        this.db2Sql = db2Sql;
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        String sql = this.db2Sql.getViewSourceSql();
        boolean isMQT = this.isMQT();
        if (!isMQT) {
            sql = this.getTableSelectSql((ITableInfo)doi);
            this.appendSeparator = false;
        } else {
            this.appendSeparator = true;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Running SQL for table source tab: " + sql));
            s_log.debug((Object)("schema=" + doi.getSchemaName()));
            s_log.debug((Object)("view name=" + doi.getSimpleName()));
        }
        PreparedStatement pstmt = conn.prepareStatement(sql);
        if (isMQT) {
            pstmt.setString(1, doi.getSchemaName());
            pstmt.setString(2, doi.getSimpleName());
        }
        return pstmt;
    }

    private boolean isMQT() {
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        boolean isMQT = false;
        if (doi.getDatabaseObjectType() == DatabaseObjectType.TABLE) {
            ITableInfo info = (ITableInfo)doi;
            if (info.getType().startsWith("MATERIALIZED")) {
                isMQT = true;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Table " + doi.getSimpleName() + " appears to be an MQT"));
                }
            } else if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Table " + doi.getSimpleName() + " appears to be a regular table"));
            }
        }
        return isMQT;
    }

    private String getTableSelectSql(ITableInfo ti) {
        String sql = this.getRegularTableSelectSql(ti);
        if (sql == null) {
            sql = this.db2Sql.getViewSourceSql();
        }
        return sql;
    }

    private String getRegularTableSelectSql(ITableInfo ti) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("select '");
        ISQLDatabaseMetaData md = this.getSession().getMetaData();
        try {
            HibernateDialect dialect = DialectFactory.getDialect((ISQLDatabaseMetaData)md);
            List<ITableInfo> tableList = Arrays.asList(ti);
            CreateScriptPreferences prefs = new CreateScriptPreferences();
            List sqls = dialect.getCreateTableSQL(tableList, md, prefs, false);
            for (String sql : sqls) {
                tmp.append(sql.replace("'", "''"));
                tmp.append(this.statementSeparator);
                tmp.append("\n");
                tmp.append("\n");
            }
        }
        catch (SQLException e) {
            s_log.error((Object)("createStatement: Unexpected exception while constructing SQL for table(" + ti.getSimpleName() + "): " + e.getMessage()), (Throwable)e);
            return null;
        }
        tmp.append("' from sysibm.sysdummy1");
        return tmp.toString();
    }

    protected String getSqlStatement() {
        return null;
    }
}

