/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPluginResources;

public class UncommentAction
extends SquirrelAction
implements ISQLPanelAction {
    private ISQLPanelAPI _panel;
    private ISQLEntryPanel _isqlEntryPanel;

    public UncommentAction(IApplication app, SyntaxPluginResources rsrc) throws IllegalArgumentException {
        super(app, (IResources)rsrc);
    }

    public UncommentAction(IApplication app, SyntaxPluginResources rsrc, ISQLEntryPanel isqlEntryPanel) {
        this(app, rsrc);
        this._isqlEntryPanel = isqlEntryPanel;
    }

    public void actionPerformed(ActionEvent evt) {
        if (null != this._isqlEntryPanel) {
            this.uncomment(this._isqlEntryPanel);
        } else if (null != this._panel) {
            this.uncomment(this._panel.getSQLEntryPanel());
        }
    }

    private void uncomment(ISQLEntryPanel sqlEntryPanel) {
        int[] bounds = sqlEntryPanel.getBoundsOfSQLToBeExecuted();
        if (bounds[0] == bounds[1]) {
            return;
        }
        int caretPosition = sqlEntryPanel.getCaretPosition();
        String textToComment = sqlEntryPanel.getText().substring(bounds[0], bounds[1]);
        String[] lines = textToComment.split("\n");
        StringBuffer uncommentedLines = new StringBuffer();
        String startOfLineComment = sqlEntryPanel.getSession().getProperties().getStartOfLineComment();
        for (int i = 0; i < lines.length; ++i) {
            if (bounds[0] + uncommentedLines.length() < caretPosition && lines[i].startsWith(startOfLineComment)) {
                caretPosition -= startOfLineComment.length();
            }
            if (lines[i].startsWith(startOfLineComment)) {
                uncommentedLines.append(lines[i].substring(startOfLineComment.length()));
            } else {
                uncommentedLines.append(lines[i]);
            }
            if (i >= lines.length - 1 && !textToComment.endsWith("\n")) continue;
            uncommentedLines.append("\n");
        }
        sqlEntryPanel.setSelectionStart(bounds[0]);
        sqlEntryPanel.setSelectionEnd(bounds[1]);
        sqlEntryPanel.replaceSelection(uncommentedLines.toString());
        sqlEntryPanel.setCaretPosition(caretPosition);
    }

    public void setSQLPanel(ISQLPanelAPI panel) {
        this._panel = panel;
    }
}

