/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.rtffix;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

final class SquirrelRtfToText {
    private Reader r;
    private StringBuilder sb;
    private StringBuilder controlWord;
    private int blockCount;
    private boolean inControlWord;

    private SquirrelRtfToText(Reader r) {
        this.r = r;
        this.sb = new StringBuilder();
        this.controlWord = new StringBuilder();
        this.blockCount = 0;
        this.inControlWord = false;
    }

    private String convert() throws IOException {
        int i = this.r.read();
        if (i != 123) {
            throw new IOException("Invalid RTF file");
        }
        block7: while ((i = this.r.read()) != -1) {
            char ch = (char)i;
            switch (ch) {
                case '\n': 
                case '\r': {
                    if (this.blockCount != 0 || !this.inControlWord) continue block7;
                    this.endControlWord();
                    continue block7;
                }
                case ' ': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.endControlWord();
                        continue block7;
                    }
                    this.sb.append(' ');
                    continue block7;
                }
                case '\\': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        if (this.controlWord.length() == 0) {
                            this.sb.append('\\');
                            this.controlWord.setLength(0);
                            this.inControlWord = false;
                            continue block7;
                        }
                        this.endControlWord();
                        this.inControlWord = true;
                        continue block7;
                    }
                    this.inControlWord = true;
                    continue block7;
                }
                case '{': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('{');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        continue block7;
                    }
                    ++this.blockCount;
                    continue block7;
                }
                case '}': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('}');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        continue block7;
                    }
                    --this.blockCount;
                    continue block7;
                }
            }
            if (this.blockCount != 0) continue;
            if (this.inControlWord) {
                this.controlWord.append(ch);
                continue;
            }
            this.sb.append(ch);
        }
        return this.sb.toString();
    }

    private void endControlWord() {
        String word = this.controlWord.toString();
        if ("par".equals(word) || "line".equals(word)) {
            this.sb.append('\n');
        } else if ("tab".equals(word)) {
            this.sb.append('\t');
        }
        this.controlWord.setLength(0);
        this.inControlWord = false;
    }

    static String getPlainText(byte[] rtf) throws IOException {
        return SquirrelRtfToText.getPlainText(new ByteArrayInputStream(rtf));
    }

    private static String getPlainText(File file) throws IOException {
        return SquirrelRtfToText.getPlainText(new BufferedReader(new FileReader(file)));
    }

    static String getPlainText(InputStream in) throws IOException {
        return SquirrelRtfToText.getPlainText(new InputStreamReader(in, "US-ASCII"));
    }

    private static String getPlainText(Reader r) throws IOException {
        String var2;
        try {
            SquirrelRtfToText converter = new SquirrelRtfToText(r);
            var2 = converter.convert();
        }
        finally {
            r.close();
        }
        return var2;
    }

    private static String getPlainText(String rtf) throws IOException {
        return SquirrelRtfToText.getPlainText(new StringReader(rtf));
    }
}

