/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.cli;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.cli.CliMessageType;
import net.sourceforge.squirrel_sql.client.cli.CliMessageUtil;
import net.sourceforge.squirrel_sql.client.cli.CliSQLExecuterHandlerAdapter;
import net.sourceforge.squirrel_sql.client.cli.CliSession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetWrapper;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.ResultAsText;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class CliSQLExecuterHandler
extends CliSQLExecuterHandlerAdapter {
    private CliSession _cliSession;
    private String _outputFile;
    private PrintWriter _printWriter;
    private FileWriter _fileWriter;
    private BufferedWriter _bufferedWriter;
    private long _counter;

    public CliSQLExecuterHandler(CliSession cliSession, String outputFile) {
        try {
            this._cliSession = cliSession;
            if (null != outputFile) {
                this.tryInitFile(outputFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void tryInitFile(String outputFile) throws IOException {
        this._outputFile = outputFile;
        File file = new File(this._outputFile);
        if (null != file.getParentFile()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("Failed to create file: " + file.getPath());
        }
        this._fileWriter = new FileWriter(outputFile, true);
        this._bufferedWriter = new BufferedWriter(this._fileWriter);
        this._printWriter = new PrintWriter(this._bufferedWriter);
    }

    @Override
    public String sqlExecutionException(Throwable th, String postErrorString) {
        String retMessage = postErrorString;
        if (null != postErrorString) {
            CliMessageUtil.showMessage(CliMessageType.ERROR, postErrorString);
        }
        if (null != th) {
            if (th instanceof SQLException) {
                retMessage = Utilities.getSqlExecutionErrorMessage((SQLException)th);
                CliMessageUtil.showMessage(CliMessageType.ERROR, retMessage);
            } else {
                throw CliMessageUtil.wrapRuntime(th);
            }
        }
        return retMessage;
    }

    @Override
    public void sqlStatementCount(int statementCount) {
    }

    @Override
    public void sqlToBeExecuted(String sql) {
    }

    @Override
    public void sqlDataUpdated(int updateCount) {
        System.out.println(updateCount + " rows updated");
    }

    @Override
    public void sqlResultSetAvailable(ResultSetWrapper rst, SQLExecutionInfo info, IDataSetUpdateableTableModel model) throws DataSetException {
        ResultSetDataSet rsds = new ResultSetDataSet();
        rsds.setLimitDataRead(true);
        DialectType dialectType = DialectFactory.getDialectType(this._cliSession.getMetaData());
        rsds.setSqlExecutionTabResultSet(rst, null, dialectType);
        ResultAsText resultAsText = new ResultAsText(rsds.getDataSetDefinition().getColumnDefinitions(), true, line -> this.onAddLine(line));
        for (Object[] row : rsds.getAllDataForReadOnly()) {
            resultAsText.addRow(row);
        }
    }

    @Override
    public void sqlExecutionComplete(SQLExecutionInfo info, int processedStatementCount, int statementCount) {
    }

    private void onAddLine(String line) {
        if (null != this._printWriter) {
            this._printWriter.print(line);
            if (++this._counter % 10000L == 0L) {
                System.out.println(this._counter + " lines written to " + this._outputFile);
            }
        } else {
            System.out.print(line);
        }
    }

    @Override
    public void sqlCloseExecutionHandler(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
        this.closeOutputFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeOutputFile() {
        block36: {
            try {
                if (null != this._printWriter) {
                    this._printWriter.flush();
                    this._printWriter.close();
                }
                if (null != this._bufferedWriter) {
                    this._bufferedWriter.flush();
                    this._bufferedWriter.close();
                }
                if (null == this._fileWriter) break block36;
            }
            catch (IOException iOException) {
                if (null == this._fileWriter) break block36;
                try {
                    this._fileWriter.flush();
                    break block36;
                }
                catch (Exception exception) {
                    break block36;
                }
                finally {
                    try {
                        this._fileWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                if (null == this._fileWriter) throw throwable;
                try {
                    this._fileWriter.flush();
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
                finally {
                    try {
                        this._fileWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                this._fileWriter.flush();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    this._fileWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        if (null == this._outputFile) return;
        System.out.println("Finshed writing file " + this._outputFile);
    }
}

