/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectToAliasCallBack;
import net.sourceforge.squirrel_sql.client.gui.db.DataCache;
import net.sourceforge.squirrel_sql.client.gui.db.DriverListCellRenderer;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.preferences.PreferenceType;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class AliasInternalFrame
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasInternalFrame.class);
    private static final int COLUMN_COUNT = 25;
    private static final ILogger s_log = LoggerController.createLogger(AliasInternalFrame.class);
    private final transient IApplication _app;
    private final ISQLAlias _sqlAlias;
    private final JLabel _titleLbl = new JLabel();
    private final int _maintType;
    private transient DriversCacheListener _driversCacheLis;
    private final JTextField _aliasName = new JTextField();
    private DriversCombo _drivers;
    private final JTextField _url = new JTextField();
    private final JTextField _userName = new JTextField();
    private final JPasswordField _password = new JPasswordField();
    private final JCheckBox _autoLogonChk = new JCheckBox(s_stringMgr.getString("AliasInternalFrame.autologon"));
    private final JCheckBox _connectAtStartupChk = new JCheckBox(s_stringMgr.getString("AliasInternalFrame.connectatstartup"));
    private final JButton _aliasPropsBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.props"));

    AliasInternalFrame(IApplication app, ISQLAlias sqlAlias, int maintType) {
        super("", true, app);
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        if (sqlAlias == null) {
            throw new IllegalArgumentException("ISQLAlias == null");
        }
        if (maintType < 1 || maintType > 3) {
            String msg = s_stringMgr.getString("AliasInternalFrame.illegalValue", maintType);
            throw new IllegalArgumentException(msg);
        }
        this._app = app;
        this._sqlAlias = sqlAlias;
        this._maintType = maintType;
        this.createUserInterface();
        this.loadData();
        this.pack();
    }

    @Override
    public void dispose() {
        if (this._driversCacheLis != null) {
            this._app.getDataCache().removeDriversListener(this._driversCacheLis);
            this._driversCacheLis = null;
        }
        super.dispose();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this._titleLbl.setText(title);
    }

    ISQLAlias getSQLAlias() {
        return this._sqlAlias;
    }

    private void loadData() {
        this._aliasName.setText(this._sqlAlias.getName());
        this._userName.setText(this._sqlAlias.getUserName());
        this._password.setText(this._sqlAlias.getPassword());
        this._autoLogonChk.setSelected(this._sqlAlias.isAutoLogon());
        this._connectAtStartupChk.setSelected(this._sqlAlias.isConnectAtStartup());
        if (this._maintType != 1) {
            this._drivers.setSelectedItem(this._sqlAlias.getDriverIdentifier());
            this._url.setText(this._sqlAlias.getUrl());
        } else {
            ISQLDriver driver = this._drivers.getSelectedDriver();
            if (driver != null) {
                this._url.setText(driver.getUrl());
            }
        }
    }

    private void performClose() {
        this.dispose();
    }

    private void performOk() {
        try {
            this.applyFromDialog(this._sqlAlias);
            if (this._maintType == 1 || this._maintType == 3) {
                this._app.getDataCache().addAlias(this._sqlAlias);
            }
            this._app.savePreferences(PreferenceType.ALIAS_DEFINITIONS);
            this.dispose();
        }
        catch (ValidationException ex) {
            this._app.showErrorDialog(ex);
        }
        catch (DuplicateObjectException ex) {
            this._app.showErrorDialog(ex);
        }
    }

    private void applyFromDialog(ISQLAlias alias) throws ValidationException {
        ISQLDriver driver = this._drivers.getSelectedDriver();
        if (driver == null) {
            throw new ValidationException(s_stringMgr.getString("AliasInternalFrame.error.nodriver"));
        }
        alias.setName(this._aliasName.getText().trim());
        alias.setDriverIdentifier(this._drivers.getSelectedDriver().getIdentifier());
        alias.setUrl(this._url.getText().trim());
        alias.setUserName(this._userName.getText().trim());
        StringBuffer buf = new StringBuffer();
        buf.append(this._password.getPassword());
        alias.setPassword(buf.toString());
        alias.setAutoLogon(this._autoLogonChk.isSelected());
        alias.setConnectAtStartup(this._connectAtStartupChk.isSelected());
    }

    private void showNewDriverDialog() {
        this._app.getWindowManager().showNewDriverInternalFrame();
    }

    private void showDriverPropertiesDialog() {
        try {
            this.applyFromDialog(this._sqlAlias);
            new AliasPropertiesCommand(this._sqlAlias, this._app).execute();
        }
        catch (Exception ex) {
            this._app.showErrorDialog(ex);
        }
    }

    private void createUserInterface() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        String winTitle = this._maintType == 2 ? s_stringMgr.getString("AliasInternalFrame.changealias", this._sqlAlias.getName()) : s_stringMgr.getString("AliasInternalFrame.addalias");
        this.setTitle(winTitle);
        this._aliasName.setColumns(25);
        this._url.setColumns(25);
        this._userName.setColumns(25);
        this._password.setColumns(25);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        super.setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 2;
        contentPane.add((Component)this._titleLbl, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 10, 5, 10);
        contentPane.add((Component)new JSeparator(), gbc);
        contentPane.add((Component)this.createDataEntryPanel(), gbc);
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 10, 5, 10);
        contentPane.add((Component)new JSeparator(), gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        ++gbc.gridy;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        this._driversCacheLis = new DriversCacheListener();
        this._app.getDataCache().addDriversListener(this._driversCacheLis);
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AliasInternalFrame.this.performClose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    private JPanel createDataEntryPanel() {
        this._aliasPropsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasInternalFrame.this.showDriverPropertiesDialog();
            }
        });
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(s_stringMgr.getString("AliasInternalFrame.name"), 4), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._aliasName, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(s_stringMgr.getString("AliasInternalFrame.driver"), 4), gbc);
        this._drivers = new DriversCombo();
        this._drivers.addItemListener(new DriversComboItemListener());
        Box driverPnl = Box.createHorizontalBox();
        driverPnl.add(this._drivers);
        driverPnl.add(Box.createHorizontalStrut(5));
        JButton newDriverBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.new"));
        newDriverBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasInternalFrame.this.showNewDriverDialog();
            }
        });
        driverPnl.add(newDriverBtn);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)driverPnl, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(s_stringMgr.getString("AliasInternalFrame.url"), 4), gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._url, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(s_stringMgr.getString("AliasInternalFrame.username"), 4), gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._userName, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(s_stringMgr.getString("AliasInternalFrame.password"), 4), gbc);
        gbc = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._password, gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._autoLogonChk, gbc);
        gbc = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._connectAtStartupChk, gbc);
        gbc = new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._aliasPropsBtn.setIcon(this._app.getResources().getIcon("aliasProperties"));
        pnl.add((Component)this._aliasPropsBtn, gbc);
        gbc = new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(s_stringMgr.getString("AliasInternalFrame.cleartext")), gbc);
        gbc = new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JPanel(), gbc);
        return pnl;
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasInternalFrame.this.performOk();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasInternalFrame.this.performClose();
            }
        });
        JButton testBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.test"));
        testBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataCache cache = AliasInternalFrame.this._app.getDataCache();
                IIdentifierFactory factory = IdentifierFactory.getInstance();
                SQLAlias testAlias = cache.createAlias(factory.createIdentifier());
                try {
                    AliasInternalFrame.this.applyFromDialog(testAlias);
                    ConnectionCallBack cb = new ConnectionCallBack(AliasInternalFrame.this._app, testAlias);
                    ConnectToAliasCommand cmd = new ConnectToAliasCommand(AliasInternalFrame.this._app, testAlias, false, cb);
                    cmd.execute();
                }
                catch (ValidationException ex) {
                    AliasInternalFrame.this._app.showErrorDialog(ex);
                }
            }
        });
        pnl.add(okBtn);
        pnl.add(closeBtn);
        pnl.add(testBtn);
        GUIUtils.setJButtonSizesTheSame(new JButton[]{okBtn, closeBtn, testBtn});
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }

    private final class DriversCacheListener
    implements IObjectCacheChangeListener {
        private DriversCacheListener() {
        }

        @Override
        public void objectAdded(ObjectCacheChangeEvent evt) {
            AliasInternalFrame.this._drivers.addItem(evt.getObject());
        }

        @Override
        public void objectRemoved(ObjectCacheChangeEvent evt) {
            AliasInternalFrame.this._drivers.removeItem(evt.getObject());
        }
    }

    private final class ConnectionCallBack
    extends ConnectToAliasCallBack {
        private ConnectionCallBack(IApplication app, SQLAlias alias) {
            super(app, alias);
        }

        @Override
        public void connected(ISQLConnection conn) {
            try {
                conn.close();
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("AliasInternalFrame.error.errorclosingconn");
                s_log.error(msg, th);
                AliasInternalFrame.this._app.showErrorDialog(msg + ": " + th.toString());
            }
            AliasInternalFrame.this.showOk(s_stringMgr.getString("AliasInternalFrame.connsuccess"));
            if (this.getAlias().isAutoLogon()) {
                AliasInternalFrame.this._userName.setText(this.getAlias().getUserName());
                AliasInternalFrame.this._password.setText(this.getAlias().getPassword());
            }
        }

        @Override
        public void sessionCreated(ISession session) {
            s_log.error(s_stringMgr.getString("AliasInternalFrame.error.sessioncreation"));
        }
    }

    private final class DriversCombo
    extends JComboBox {
        private Map<IIdentifier, ISQLDriver> _map = new HashMap<IIdentifier, ISQLDriver>();
        SquirrelPreferences prefs = AliasInternalFrame.access$600(AliasInternalFrame.this).getSquirrelPreferences();

        DriversCombo() {
            SquirrelResources res = AliasInternalFrame.this._app.getResources();
            this.setRenderer(new DriverListCellRenderer((Icon)res.getIcon("list.driver.found"), res.getIcon("list.driver.notfound")));
            ArrayList<ISQLDriver> list = new ArrayList<ISQLDriver>();
            Iterator<ISQLDriver> it = AliasInternalFrame.this._app.getDataCache().drivers();
            while (it.hasNext()) {
                ISQLDriver sqlDriver = it.next();
                if (this.prefs.getShowLoadedDriversOnly() && !sqlDriver.isJDBCDriverClassLoaded()) continue;
                this._map.put(sqlDriver.getIdentifier(), sqlDriver);
                list.add(sqlDriver);
            }
            Collections.sort(list, new DriverComparator());
            it = list.iterator();
            while (it.hasNext()) {
                this.addItem(it.next());
            }
        }

        void setSelectedItem(IIdentifier id) {
            super.setSelectedItem(this._map.get(id));
        }

        ISQLDriver getSelectedDriver() {
            return (ISQLDriver)this.getSelectedItem();
        }

        private class DriverComparator
        implements Comparator<ISQLDriver>,
        Serializable {
            private DriverComparator() {
            }

            @Override
            public int compare(ISQLDriver leftDriver, ISQLDriver rightDriver) {
                if (leftDriver.isJDBCDriverClassLoaded() && !rightDriver.isJDBCDriverClassLoaded()) {
                    return -1;
                }
                if (!leftDriver.isJDBCDriverClassLoaded() && rightDriver.isJDBCDriverClassLoaded()) {
                    return 1;
                }
                return leftDriver.toString().compareToIgnoreCase(rightDriver.toString());
            }
        }
    }

    private final class DriversComboItemListener
    implements ItemListener {
        private DriversComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            ISQLDriver driver = (ISQLDriver)evt.getItem();
            if (driver != null) {
                AliasInternalFrame.this._url.setText(driver.getUrl());
            }
        }
    }

    public static interface IMaintenanceType {
        public static final int NEW = 1;
        public static final int MODIFY = 2;
        public static final int COPY = 3;
    }
}

