/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasSchemaDetailProperties;
import net.sourceforge.squirrel_sql.client.gui.db.SchemaLoadInfo;
import net.sourceforge.squirrel_sql.client.gui.db.SchemaNameLoadInfo;
import net.sourceforge.squirrel_sql.client.gui.db.SchemaTableTypeCombination;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;

public class SQLAliasSchemaProperties
implements Serializable {
    SQLAliasSchemaDetailProperties[] _schemaDetails = new SQLAliasSchemaDetailProperties[0];
    public static final int GLOBAL_STATE_LOAD_ALL_CACHE_NONE = 0;
    public static final int GLOBAL_STATE_LOAD_AND_CACHE_ALL = 1;
    public static final int GLOBAL_STATE_SPECIFY_SCHEMAS_BY_LIKE_STRING = 3;
    public static final int GLOBAL_STATE_SPECIFY_SCHEMAS = 2;
    private int _globalState = 0;
    private boolean _cacheSchemaIndependentMetaData;
    private String _byLikeStringInclude;
    private String _byLikeStringExclude;

    public SQLAliasSchemaDetailProperties[] getSchemaDetails() {
        return this._schemaDetails;
    }

    public void setSchemaDetails(SQLAliasSchemaDetailProperties[] schemaDetails) {
        this._schemaDetails = schemaDetails;
    }

    public int getGlobalState() {
        return this._globalState;
    }

    public void setGlobalState(int globalState) {
        this._globalState = globalState;
    }

    public boolean isCacheSchemaIndependentMetaData() {
        return this._cacheSchemaIndependentMetaData;
    }

    public void setCacheSchemaIndependentMetaData(boolean b) {
        this._cacheSchemaIndependentMetaData = b;
    }

    public boolean loadSchemaIndependentMetaData(SQLAliasSchemaProperties schemaPropsCacheIsBasedOn) {
        if (null == schemaPropsCacheIsBasedOn) {
            return true;
        }
        return !schemaPropsCacheIsBasedOn._cacheSchemaIndependentMetaData || !this._cacheSchemaIndependentMetaData;
    }

    public SchemaLoadInfo[] fetchSchemaLoadInfos(SQLAliasSchemaProperties schemaPropsCacheIsBasedOn, String[] tableTypes, String[] viewTypes, String[] allSchemas) {
        if (null == schemaPropsCacheIsBasedOn) {
            return this.fetchSchemasToLoadDefault(tableTypes, viewTypes, allSchemas);
        }
        if (1 == this._globalState && 1 == schemaPropsCacheIsBasedOn._globalState) {
            return new SchemaLoadInfo[0];
        }
        if (2 == this._globalState && 2 == schemaPropsCacheIsBasedOn._globalState) {
            return this.fetchSpecifiedSchemasRespectingCache(schemaPropsCacheIsBasedOn, tableTypes, viewTypes);
        }
        return this.fetchSchemasToLoadDefault(tableTypes, viewTypes, allSchemas);
    }

    private SchemaLoadInfo[] fetchSchemasToLoadDefault(String[] tableTypes, String[] viewTypes, String[] allSchemas) {
        if (0 == this._globalState || 1 == this._globalState) {
            return new SchemaLoadInfo[]{new SchemaLoadInfo(this.addStringArrays(tableTypes, viewTypes))};
        }
        if (3 == this._globalState) {
            return this.fetchSpecifiedByLikeString(tableTypes, viewTypes, allSchemas);
        }
        if (2 == this._globalState) {
            return this.fetchSpecifiedSchemasForEmptyCache(tableTypes, viewTypes);
        }
        throw new IllegalStateException("Undefined global state " + this._globalState);
    }

    private SchemaLoadInfo[] fetchSpecifiedSchemasRespectingCache(SQLAliasSchemaProperties schemaPropsCacheIsBasedOn, String[] tableTypes, String[] viewTypes) {
        ArrayList<SchemaLoadInfo> ret = new ArrayList<SchemaLoadInfo>();
        for (int i = 0; i < this._schemaDetails.length; ++i) {
            SQLAliasSchemaDetailProperties cachedDetailProp = this.fetchMatchingDetail(this._schemaDetails[i].getSchemaName(), schemaPropsCacheIsBasedOn._schemaDetails);
            SchemaLoadInfo buf = new SchemaLoadInfo(this.addStringArrays(tableTypes, viewTypes));
            buf.setSchemaName(this._schemaDetails[i].getSchemaName());
            ArrayList<String> tableTypesToLoad = new ArrayList<String>();
            if (this.needsLoading(this._schemaDetails[i].getTable(), null == cachedDetailProp ? null : Integer.valueOf(cachedDetailProp.getTable()))) {
                tableTypesToLoad.addAll(Arrays.asList(tableTypes));
            }
            if (this.needsLoading(this._schemaDetails[i].getView(), null == cachedDetailProp ? null : Integer.valueOf(cachedDetailProp.getView()))) {
                tableTypesToLoad.addAll(Arrays.asList(viewTypes));
            }
            buf.setLoadProcedures(this.needsLoading(this._schemaDetails[i].getProcedure(), null == cachedDetailProp ? null : Integer.valueOf(cachedDetailProp.getProcedure())));
            if (0 < tableTypesToLoad.size() || buf.isLoadProcedures()) {
                buf.setTableTypes(tableTypesToLoad.toArray(new String[tableTypesToLoad.size()]));
                ret.add(buf);
            }
            buf.setLoadUDTs(this.needsLoading(this._schemaDetails[i].getUDT(), null == cachedDetailProp ? null : Integer.valueOf(cachedDetailProp.getUDT())));
            if (0 >= tableTypesToLoad.size() && !buf.isLoadUDTs()) continue;
            buf.setTableTypes(tableTypesToLoad.toArray(new String[tableTypesToLoad.size()]));
            ret.add(buf);
        }
        return ret.toArray(new SchemaLoadInfo[0]);
    }

    private SchemaLoadInfo[] fetchSpecifiedSchemasForEmptyCache(String[] tableTypes, String[] viewTypes) {
        ArrayList<SchemaLoadInfo> schemaLoadInfos = new ArrayList<SchemaLoadInfo>();
        for (int i = 0; i < this._schemaDetails.length; ++i) {
            if (2 == this._schemaDetails[i].getTable() && 2 == this._schemaDetails[i].getView() && 2 == this._schemaDetails[i].getProcedure() && 2 == this._schemaDetails[i].getUDT()) continue;
            SchemaLoadInfo schemaLoadInfo = new SchemaLoadInfo(this.addStringArrays(tableTypes, viewTypes));
            schemaLoadInfo.setSchemaName(this._schemaDetails[i].getSchemaName());
            schemaLoadInfo.setTableTypes(new String[0]);
            if (2 != this._schemaDetails[i].getTable()) {
                schemaLoadInfo.setTableTypes(this.addStringArrays(schemaLoadInfo.getTableTypes(), tableTypes));
            }
            if (2 != this._schemaDetails[i].getView()) {
                schemaLoadInfo.setTableTypes(this.addStringArrays(schemaLoadInfo.getTableTypes(), viewTypes));
            }
            if (2 != this._schemaDetails[i].getProcedure()) {
                schemaLoadInfo.setLoadProcedures(true);
            } else {
                schemaLoadInfo.setLoadProcedures(false);
            }
            if (2 != this._schemaDetails[i].getUDT()) {
                schemaLoadInfo.setLoadUDTs(true);
            } else {
                schemaLoadInfo.setLoadUDTs(false);
            }
            schemaLoadInfos.add(schemaLoadInfo);
        }
        return schemaLoadInfos.toArray(new SchemaLoadInfo[0]);
    }

    private SchemaLoadInfo[] fetchSpecifiedByLikeString(String[] tableTypes, String[] viewTypes, String[] allSchemas) {
        ArrayList<SchemaLoadInfo> ret = new ArrayList<SchemaLoadInfo>();
        for (String schemaName : this.getSchemaNamesMatchingLikeStrings(allSchemas)) {
            SchemaLoadInfo schemaLoadInfo = new SchemaLoadInfo(this.addStringArrays(tableTypes, viewTypes));
            schemaLoadInfo.setSchemaName(schemaName);
            ret.add(schemaLoadInfo);
        }
        return ret.toArray(new SchemaLoadInfo[0]);
    }

    private String[] addStringArrays(String[] tableTypes, String[] viewTypes) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(tableTypes));
        ret.addAll(Arrays.asList(viewTypes));
        return ret.toArray(new String[ret.size()]);
    }

    private boolean needsLoading(int loadingID, Integer cachedLoadingID) {
        if (2 == loadingID) {
            return false;
        }
        return 1 != loadingID || null == cachedLoadingID || 1 != cachedLoadingID;
    }

    private SQLAliasSchemaDetailProperties fetchMatchingDetail(String schemaName, SQLAliasSchemaDetailProperties[] schemaDetails) {
        for (int i = 0; i < schemaDetails.length; ++i) {
            if (!schemaDetails[i].getSchemaName().equals(schemaName)) continue;
            return schemaDetails[i];
        }
        return null;
    }

    public SchemaTableTypeCombination[] fetchAllSchemaTableTypeCombinationsNotToBeCached(String[] tableTypes, String[] viewTypes) {
        ArrayList<SchemaTableTypeCombination> ret = new ArrayList<SchemaTableTypeCombination>();
        for (int i = 0; i < this._schemaDetails.length; ++i) {
            SchemaTableTypeCombination buf;
            if (1 != this._schemaDetails[i].getTable()) {
                buf = new SchemaTableTypeCombination();
                buf.schemaName = this._schemaDetails[i].getSchemaName();
                buf.types = tableTypes;
                ret.add(buf);
            }
            if (1 == this._schemaDetails[i].getView()) continue;
            buf = new SchemaTableTypeCombination();
            buf.schemaName = this._schemaDetails[i].getSchemaName();
            buf.types = viewTypes;
            ret.add(buf);
        }
        return ret.toArray(new SchemaTableTypeCombination[ret.size()]);
    }

    public String[] fetchAllSchemaProceduresNotToBeCached() {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < this._schemaDetails.length; ++i) {
            if (1 == this._schemaDetails[i].getProcedure()) continue;
            ret.add(this._schemaDetails[i].getSchemaName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String[] fetchAllSchemaUDTsNotToBeCached() {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < this._schemaDetails.length; ++i) {
            if (1 == this._schemaDetails[i].getUDT()) continue;
            ret.add(this._schemaDetails[i].getSchemaName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public boolean fetchExpectsSomeCachedData() {
        if (this._cacheSchemaIndependentMetaData || 1 == this._globalState) {
            return true;
        }
        if (2 == this._globalState) {
            for (int i = 0; i < this._schemaDetails.length; ++i) {
                if (1 != this._schemaDetails[i].getTable() && 1 != this._schemaDetails[i].getView() && 1 != this._schemaDetails[i].getProcedure() && 1 != this._schemaDetails[i].getUDT()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean loadSchemaNames(SQLAliasSchemaProperties schemaPropsCacheIsBasedOn) {
        return 1 == this._globalState && 1 == schemaPropsCacheIsBasedOn._globalState;
    }

    public SchemaNameLoadInfo fetchSchemaNameLoadInfo(SQLAliasSchemaProperties schemaPropsCacheIsBasedOn, String[] allSchemas) {
        SchemaNameLoadInfo ret = new SchemaNameLoadInfo();
        if (1 == this._globalState && null != schemaPropsCacheIsBasedOn && 1 == schemaPropsCacheIsBasedOn._globalState) {
            ret.state = 0;
        } else if (3 == this._globalState) {
            ret.state = 2;
            ArrayList<String> schemaNames = this.getSchemaNamesMatchingLikeStrings(allSchemas);
            ret.schemaNames = schemaNames.toArray(new String[0]);
        } else if (2 == this._globalState) {
            ArrayList<String> schemaNames = new ArrayList<String>();
            ret.state = 2;
            for (int i = 0; i < this._schemaDetails.length; ++i) {
                if (2 == this._schemaDetails[i].getTable() && 2 == this._schemaDetails[i].getView() && 2 == this._schemaDetails[i].getProcedure()) continue;
                schemaNames.add(this._schemaDetails[i].getSchemaName());
            }
            ret.schemaNames = schemaNames.toArray(new String[0]);
        } else {
            ret.state = 1;
        }
        return ret;
    }

    private ArrayList<String> getSchemaNamesMatchingLikeStrings(String[] allSchemas) {
        ArrayList<String> schemaNames = new ArrayList<String>();
        FilterMatcher filterMatcher = new FilterMatcher(this._byLikeStringInclude, this._byLikeStringExclude);
        for (String schemaName : allSchemas) {
            if (!filterMatcher.matches(schemaName)) continue;
            schemaNames.add(schemaName);
        }
        return schemaNames;
    }

    public String getByLikeStringInclude() {
        return this._byLikeStringInclude;
    }

    public void setByLikeStringInclude(String byLikeStringInclude) {
        this._byLikeStringInclude = byLikeStringInclude;
    }

    public String getByLikeStringExclude() {
        return this._byLikeStringExclude;
    }

    public void setByLikeStringExclude(String byLikeStringExclude) {
        this._byLikeStringExclude = byLikeStringExclude;
    }
}

