/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.session.MainPanelTabSelectionListener;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ObjectTreeTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.BaseSQLTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.SQLTab;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MainPanel
extends JPanel {
    private static final String PREFS_KEY_SELECTED_TAB_IX = "squirrelSql_mainPanel_sel_tab_ix";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MainPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(MainPanel.class);
    private transient ISession _session;
    private final JTabbedPane _tabbedPane = UIFactory.getInstance().createTabbedPane();
    private PropertyChangeListener _propsListener;
    private ChangeListener _tabPnlListener;
    private List<IMainPanelTab> _tabs = new ArrayList<IMainPanelTab>();
    private ArrayList<MainPanelTabSelectionListener> _mainPanelTabSelectionListeners = new ArrayList();

    MainPanel(ISession session, TitleFilePathHandler titleFileHandler) {
        super(new BorderLayout());
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        this._session = session;
        this.addMainPanelTab(new ObjectTreeTab(), 79);
        this.addMainPanelTab(new SQLTab(this._session, titleFileHandler), 81);
        this.add((Component)this._tabbedPane, "Center");
        this.propertiesHaveChanged(null);
        this._tabs.get(this._tabbedPane.getSelectedIndex()).select();
        GUIUtils.listenToMouseWheelClickOnTab(this._tabbedPane, (tabIndex, tabComponent) -> this.onMouseWheelClickedOnTab(tabIndex));
    }

    private void onMouseWheelClickedOnTab(int tabIndex) {
        this._tabs.get(tabIndex).mouseWheelClickedOnTab();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._propsListener == null) {
            this._propsListener = evt -> this.propertiesHaveChanged(evt.getPropertyName());
            this._session.getProperties().addPropertyChangeListener(this._propsListener);
        }
        this._tabPnlListener = evt -> this.performStateChanged();
        this._tabbedPane.addChangeListener(this._tabPnlListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._propsListener != null) {
            this._session.getProperties().removePropertyChangeListener(this._propsListener);
            this._propsListener = null;
        }
        if (this._tabPnlListener != null) {
            this._tabbedPane.removeChangeListener(this._tabPnlListener);
            this._tabPnlListener = null;
        }
    }

    public int addMainPanelTab(IMainPanelTab tab) {
        return this.addMainPanelTab(tab, null);
    }

    public int addMainPanelTab(IMainPanelTab tab, Integer mnemonic) {
        int prefIx;
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        tab.setSession(this._session);
        int idx = this.getTabIndex(tab);
        if (idx != -1) {
            this._tabbedPane.removeTabAt(idx);
            this._tabs.set(idx, tab);
        } else {
            idx = this._tabbedPane.getTabCount();
            this._tabs.add(tab);
        }
        this._tabbedPane.insertTab(tab.getTitle(), null, tab.getComponent(), tab.getHint(), idx);
        if (null != tab.getTabComponent()) {
            this._tabbedPane.setTabComponentAt(idx, tab.getTabComponent());
        }
        if (idx == (prefIx = Props.getInt(PREFS_KEY_SELECTED_TAB_IX, 0))) {
            this._tabbedPane.setSelectedIndex(prefIx);
        }
        if (null != mnemonic) {
            this._tabbedPane.setMnemonicAt(idx, mnemonic);
        }
        return idx;
    }

    public void insertMainPanelTab(IMainPanelTab tab, int idx, boolean selectInsertedTab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        tab.setSession(this._session);
        int checkIdx = this.getTabIndex(tab);
        if (checkIdx != -1) {
            throw new IllegalArgumentException("A tab with the same title already exists at index " + checkIdx);
        }
        this._tabs.add(idx, tab);
        this._tabbedPane.insertTab(tab.getTitle(), null, tab.getComponent(), tab.getHint(), idx);
        if (null != tab.getTabComponent()) {
            this._tabbedPane.setTabComponentAt(idx, tab.getTabComponent());
        }
        if (selectInsertedTab) {
            this._tabbedPane.setSelectedIndex(idx);
        }
    }

    public int getTabIndex(IMainPanelTab tab) {
        int checkIdx = null == tab.getTabComponent() ? this._tabbedPane.indexOfTab(tab.getTitle()) : this._tabbedPane.indexOfTabComponent(tab.getTabComponent());
        return checkIdx;
    }

    public int removeMainPanelTab(IMainPanelTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        int idx = this.getTabIndex(tab);
        if (idx == -1) {
            return idx;
        }
        this._tabs.remove(idx);
        this._tabbedPane.removeTabAt(idx);
        return idx;
    }

    private void updateState() {
        int idx = this._tabbedPane.getSelectedIndex();
        if (idx != -1) {
            IMainPanelTab selectedMainPanelTab = this._tabs.get(idx);
            selectedMainPanelTab.select();
            for (MainPanelTabSelectionListener mainPanelTabSelectionListener : this._mainPanelTabSelectionListeners.toArray(new MainPanelTabSelectionListener[0])) {
                mainPanelTabSelectionListener.mainTabSelected(selectedMainPanelTab);
            }
        }
        this._session.getApplication().getActionCollection().activationChanged(this._session.getSessionInternalFrame());
    }

    public IMainPanelTab getSelectedMainTab() {
        int idx = this._tabbedPane.getSelectedIndex();
        if (idx == -1) {
            return null;
        }
        return this._tabs.get(idx);
    }

    void sessionClosing(ISession session) {
        Iterator<IMainPanelTab> it = this._tabs.iterator();
        while (it.hasNext()) {
            try {
                it.next().sessionClosing(session);
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("MainPanel.error.sessionclose");
                this._session.getApplication().showErrorDialog(msg, th);
                s_log.error(msg, th);
            }
        }
    }

    public void sessionWindowClosing() {
        for (SQLPanel sqlPanel : this.getAllSQLPanels()) {
            sqlPanel.sessionWindowClosing();
        }
        this.getObjectTreePanel().sessionWindowClosing();
        int selIx = this._tabbedPane.getSelectedIndex();
        if (selIx == 0 || selIx == 1) {
            Props.putInt(PREFS_KEY_SELECTED_TAB_IX, selIx);
        }
    }

    private void propertiesHaveChanged(String propertyName) {
        SessionProperties props = this._session.getProperties();
        if (propertyName == null || propertyName.equals("mainTabPlacement")) {
            this._tabbedPane.setTabPlacement(props.getMainTabPlacement());
        }
    }

    void performStateChanged() {
        this._tabbedPane.requestFocusInWindow();
        this.updateState();
    }

    ObjectTreePanel getObjectTreePanel() {
        ObjectTreeTab tab = (ObjectTreeTab)this._tabs.get(0);
        return (ObjectTreePanel)tab.getComponent();
    }

    public IMainPanelTab getMainPanelTabAt(int tabIndex) {
        return this._tabs.get(tabIndex);
    }

    public int getMainTabCount() {
        return this._tabs.size();
    }

    public int getSelectedMainTabIndex() {
        return this._tabbedPane.getSelectedIndex();
    }

    public void selectMainTab(int tabIndex) {
        this._tabbedPane.setSelectedIndex(tabIndex);
    }

    public SQLPanel getMainSQLPanel() {
        for (IMainPanelTab tab : this._tabs) {
            if (!(tab instanceof SQLTab)) continue;
            return ((SQLTab)tab).getSQLPanel();
        }
        throw new IllegalStateException("No SQLTab instance found. This shouldn't happen.");
    }

    public SQLPanel getSelectedSQLPanel() {
        IMainPanelTab selectedMainTab = this.getSelectedMainTab();
        if (selectedMainTab instanceof BaseSQLTab) {
            return ((BaseSQLTab)selectedMainTab).getSQLPanel();
        }
        if (selectedMainTab instanceof AdditionalSQLTab) {
            return ((AdditionalSQLTab)selectedMainTab).getSQLPanel();
        }
        return null;
    }

    public SQLPanel getSelectedOrMainSQLPanel() {
        SQLPanel ret = this.getSelectedSQLPanel();
        if (null != ret) {
            return ret;
        }
        return this.getMainSQLPanel();
    }

    List<SQLPanel> getAllSQLPanels() {
        ArrayList<SQLPanel> ret = new ArrayList<SQLPanel>();
        for (IMainPanelTab tab : this._tabs) {
            if (!(tab instanceof BaseSQLTab)) continue;
            ret.add(((BaseSQLTab)tab).getSQLPanel());
        }
        return ret;
    }

    public void addMainPanelTabSelectionListener(MainPanelTabSelectionListener mainPanelTabSelectionListener) {
        this._mainPanelTabSelectionListeners.remove(mainPanelTabSelectionListener);
        this._mainPanelTabSelectionListeners.add(mainPanelTabSelectionListener);
    }

    public void removeMainPanelTabSelectionListener(MainPanelTabSelectionListener mainPanelTabSelectionListener) {
        this._mainPanelTabSelectionListeners.remove(mainPanelTabSelectionListener);
    }

    public static interface ITabIndexes {
        public static final int OBJECT_TREE_TAB = 0;
        public static final int SQL_TAB = 1;
    }
}

