/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session.rowcolumnlabel;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import net.sourceforge.squirrel_sql.client.gui.session.MainPanel;
import net.sourceforge.squirrel_sql.client.gui.session.rowcolumnlabel.CaretPositionInfo;
import net.sourceforge.squirrel_sql.client.gui.session.rowcolumnlabel.RowColumnLabelSQLEntryPanelHandler;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RowColumnLabel
extends JLabel {
    private RowColumnLabelSQLEntryPanelHandler _rowColumnLabelSqlEntryPanelHandler;
    private StringBuffer _msg = new StringBuffer();
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RowColumnLabel.class);
    private Dimension _dim;

    public RowColumnLabel(ISQLEntryPanel sqlEntryPanel) {
        super(" ", 0);
        this.init(new RowColumnLabelSQLEntryPanelHandler(sqlEntryPanel, e -> this.onCaretUpdate(e)));
    }

    public RowColumnLabel(MainPanel mainPanel) {
        super(" ", 0);
        this.init(new RowColumnLabelSQLEntryPanelHandler(mainPanel, e -> this.onCaretUpdate(e)));
    }

    private void init(RowColumnLabelSQLEntryPanelHandler rowColumnLabelSqlEntryPanelHandler) {
        this._rowColumnLabelSqlEntryPanelHandler = rowColumnLabelSqlEntryPanelHandler;
        this.writePosition(0, 0, 0);
        this.setToolTipText(s_stringMgr.getString("RowColumnLabel.tooltip"));
    }

    private void onCaretUpdate(CaretEvent e) {
        CaretPositionInfo caretPositionInfo = this._rowColumnLabelSqlEntryPanelHandler.getCaretPositionInfo();
        if (null == caretPositionInfo) {
            return;
        }
        this.writePosition(caretPositionInfo.getCaretLineNumber(), caretPositionInfo.getCaretLinePosition(), caretPositionInfo.getCaretPosition());
    }

    private void writePosition(int caretLineNumber, int caretLinePosition, int caretPosition) {
        this._msg.setLength(0);
        this._msg.append(caretLineNumber + 1).append(",").append(caretLinePosition + 1).append(" / ").append(caretPosition + 1);
        this.setText(this._msg.toString());
    }

    @Override
    public Dimension getPreferredSize() {
        if (null == this._dim) {
            this._dim = this.calcPrefSize();
        }
        return this._dim;
    }

    private Dimension calcPrefSize() {
        Insets ins;
        Dimension dim = super.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        dim.width = fm.stringWidth("000,000 / 00000000");
        Border border = this.getBorder();
        if (border != null && (ins = border.getBorderInsets(this)) != null) {
            dim.width += ins.left + ins.right;
        }
        if ((ins = this.getInsets()) != null) {
            dim.width += ins.left + ins.right;
        }
        return dim;
    }
}

