/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ErrorPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabIconManager;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabbedExcutionPanelUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ResultTabClosing {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultTabClosing.class);
    private final TabIconManager _tabIconManager;
    private final JTabbedPane _tabbedExecutionsPanel;

    public ResultTabClosing(TabIconManager tabIconManager, JTabbedPane tabbedExecutionsPanel) {
        this._tabIconManager = tabIconManager;
        this._tabbedExecutionsPanel = tabbedExecutionsPanel;
    }

    public boolean confirmSqlPanelClose(ArrayList<JComponent> allTabs) {
        for (JComponent tab : allTabs) {
            if (!this.isAnchored(tab)) continue;
            String msg = s_stringMgr.getString("AnchorTabClosingHelper.removeAnchoredPanel.close.sqlpanel.with.anchored.msg");
            String title = s_stringMgr.getString("AnchorTabClosingHelper.removeAnchoredPanel.close.sqlpanel.with.anchored.title");
            return 0 == JOptionPane.showConfirmDialog(Main.getApplication().getMainFrame(), msg, title, 1, 3);
        }
        return true;
    }

    public void closeTabs(List<JComponent> tabs) {
        this.closeTabs(tabs, false);
    }

    public void closeTabs(List<JComponent> tabs, boolean isMemoryCleanUp) {
        boolean closeAll = true;
        if (!isMemoryCleanUp && 0L < tabs.stream().filter(t -> this.isAnchored((JComponent)t)).count()) {
            Object[] selectionValues = new String[]{s_stringMgr.getString("AnchorTabClosingHelper.removeAnchoredPanel.opt.remove.non.anchored.only"), s_stringMgr.getString("AnchorTabClosingHelper.removeAnchoredPanel.opt.remove.all"), s_stringMgr.getString("AnchorTabClosingHelper.removeAnchoredPanel.opt.remove.cancel")};
            int selectIndex = JOptionPane.showOptionDialog(this._tabbedExecutionsPanel, s_stringMgr.getString("AnchorTabClosingHelper.removeAnchoredPanel"), s_stringMgr.getString("AnchorTabClosingHelper.removeAnchoredPanel.title"), -1, 3, null, selectionValues, selectionValues[0]);
            if (selectIndex == 0) {
                closeAll = false;
            } else if (selectIndex == 1) {
                closeAll = true;
            } else {
                return;
            }
        }
        for (JComponent tab : tabs) {
            if (!closeAll && this.isAnchored(tab)) continue;
            this._closeTab(tab);
        }
    }

    void closeTab(JComponent tab) {
        if (this.isAnchored(tab)) {
            String msg = s_stringMgr.getString("AnchorTabClosingHelper.removeAnchoredPanel.close.anchored.msg");
            String title = s_stringMgr.getString("AnchorTabClosingHelper.removeAnchoredPanel.close.anchored.title");
            if (0 != JOptionPane.showConfirmDialog(Main.getApplication().getMainFrame(), msg, title, 1, 3)) {
                return;
            }
        }
        this._closeTab(tab);
    }

    public void closeTabAt(int index) {
        JComponent tab = (JComponent)this._tabbedExecutionsPanel.getComponentAt(index);
        this._closeTab(tab);
    }

    public boolean isAnchored(JComponent tab) {
        int indexOfTab = TabbedExcutionPanelUtil.getIndexOfTab(tab, this._tabbedExecutionsPanel);
        return this.isAnchoredAt(indexOfTab);
    }

    public boolean isAnchoredAt(int indexOfTab) {
        return this._tabIconManager.getAnchorIcon() == this._tabbedExecutionsPanel.getIconAt(indexOfTab);
    }

    private void _closeTab(Component tab) {
        if (tab instanceof ErrorPanel) {
            this._tabbedExecutionsPanel.remove(tab);
        } else if (tab instanceof ResultTab) {
            ((ResultTab)tab).disposeTab();
            this._tabbedExecutionsPanel.remove(tab);
        } else if (tab instanceof CancelPanel) {
            ((CancelPanel)tab).closeBtn.doClick();
        }
    }
}

