/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.TimeScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.XYPair;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumnFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

class XYChartCreator {
    private String _title;
    private JFreeChart _chart;
    private String _label;

    public XYChartCreator(DataScale xAxisDataScale, DataScale yAxisDataScale, DataScaleTable dataScaleTable, boolean isDifferencesChart, TimeScale timeScale) {
        this._title = isDifferencesChart ? "Difference chart for x = " + xAxisDataScale.getColumnDisplayDefinition().getColumnName() + ", y = \u0394 (" + yAxisDataScale.getColumnDisplayDefinition().getColumnName() + ")" : "Chart for x = " + xAxisDataScale.getColumnDisplayDefinition().getColumnName() + ", y = " + yAxisDataScale.getColumnDisplayDefinition().getColumnName();
        DefaultXYDataset defaultXYDataset = new DefaultXYDataset();
        ArrayList<Double> xValues = dataScaleTable.getDoubleValuesForColumn(xAxisDataScale.getColumnDisplayDefinition());
        ArrayList<Double> yValues = dataScaleTable.getDoubleValuesForColumn(yAxisDataScale.getColumnDisplayDefinition());
        ArrayList<XYPair> pairs = XYPair.createSortedPairs(xValues, yValues);
        if (isDifferencesChart) {
            this.convertYValuesToDifferences(pairs, timeScale);
        }
        double[][] series = new double[2][pairs.size()];
        for (int i = 0; i < pairs.size(); ++i) {
            series[0][i] = pairs.get(i).getX();
            series[1][i] = pairs.get(i).getY();
        }
        defaultXYDataset.addSeries((Comparable)((Object)this._title), series);
        this.createChart(this._title, defaultXYDataset, xAxisDataScale.getColumnDisplayDefinition(), yAxisDataScale.getColumnDisplayDefinition(), isDifferencesChart);
        this._label = "";
    }

    private void createChart(String title, DefaultXYDataset defaultXYDataset, ColumnDisplayDefinition xColumnDisplayDefinition, ColumnDisplayDefinition yColumnDisplayDefinition, boolean isDifferencesChart) {
        NumberAxis yAxis;
        DateAxis xAxis;
        if (IndexedColumnFactory.isTemporal(xColumnDisplayDefinition)) {
            xAxis = new DateAxis(xColumnDisplayDefinition.getColumnName());
        } else {
            xAxis = new NumberAxis(xColumnDisplayDefinition.getColumnName());
            ((NumberAxis)xAxis).setAutoRangeIncludesZero(false);
        }
        if (!isDifferencesChart && IndexedColumnFactory.isTemporal(yColumnDisplayDefinition)) {
            yAxis = new DateAxis(yColumnDisplayDefinition.getColumnName());
        } else {
            yAxis = isDifferencesChart ? new NumberAxis("\u0394 (" + yColumnDisplayDefinition.getColumnName() + ")") : new NumberAxis(yColumnDisplayDefinition.getColumnName());
            yAxis.setAutoRangeIncludesZero(false);
        }
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        XYPlot plot = new XYPlot((XYDataset)defaultXYDataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        StandardXYToolTipGenerator toolTipGenerator = this.createToolTipGenerator(xColumnDisplayDefinition, yColumnDisplayDefinition, isDifferencesChart);
        renderer.setDefaultToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
        this._chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        StandardChartTheme.createJFreeTheme().apply(this._chart);
    }

    private StandardXYToolTipGenerator createToolTipGenerator(ColumnDisplayDefinition xColumnDisplayDefinition, ColumnDisplayDefinition yColumnDisplayDefinition, boolean isDifferencesChart) {
        boolean isYTemporal;
        boolean isXTemporal = IndexedColumnFactory.isTemporal(xColumnDisplayDefinition);
        boolean bl = isYTemporal = IndexedColumnFactory.isTemporal(yColumnDisplayDefinition) && false == isDifferencesChart;
        StandardXYToolTipGenerator toolTipGenerator = isXTemporal && isYTemporal ? new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getInstance(), DateFormat.getInstance()) : (false == isXTemporal && isYTemporal ? new StandardXYToolTipGenerator("{0}: ({1}, {2})", NumberFormat.getNumberInstance(), DateFormat.getInstance()) : (isXTemporal && false == isYTemporal ? new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getInstance(), NumberFormat.getNumberInstance()) : new StandardXYToolTipGenerator()));
        return toolTipGenerator;
    }

    private void convertYValuesToDifferences(ArrayList<XYPair> pairsSortedByXValues, TimeScale timeScale) {
        if (pairsSortedByXValues.size() < 2) {
            return;
        }
        double formerYValue = pairsSortedByXValues.get(0).getY();
        for (int i = 1; i < pairsSortedByXValues.size(); ++i) {
            double buf = pairsSortedByXValues.get(i).getY();
            double diff = buf - formerYValue;
            if (null != timeScale) {
                diff = timeScale.scale(diff);
            }
            pairsSortedByXValues.get(i - 1).setY(diff);
            formerYValue = buf;
        }
        int lastIx = pairsSortedByXValues.size() - 1;
        pairsSortedByXValues.get(lastIx).setY(pairsSortedByXValues.get(lastIx - 1).getY());
    }

    public String getTitle() {
        return this._title;
    }

    public JFreeChart getChart() {
        return this._chart;
    }

    public String getLabel() {
        return this._label;
    }
}

