/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor;
import net.sourceforge.squirrel_sql.fw.gui.action.AbstractExportCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvController;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.DataExportCSVWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.JTableExportData;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TableExportCsvCommand
extends AbstractExportCommand {
    static ILogger s_log = LoggerController.createLogger(TableExportCsvCommand.class);
    JTable _table;

    public TableExportCsvCommand(JTable table) {
        this._table = table;
    }

    @Override
    protected boolean checkMissingData(String sepChar) {
        int firstSelectedColIdx = this._table.getSelectedColumn();
        int lastSelectedColIdx = firstSelectedColIdx + this._table.getSelectedColumnCount();
        int firstSelectedRowIdx = this._table.getSelectedRow();
        int lastSelectedRowIdx = firstSelectedRowIdx + this._table.getSelectedRowCount();
        for (int colIdx = this._table.getSelectedColumn(); colIdx < lastSelectedColIdx; ++colIdx) {
            ExtTableColumn col;
            int sqlType;
            if (!(this._table.getColumnModel().getColumn(colIdx) instanceof ExtTableColumn) || (sqlType = (col = (ExtTableColumn)this._table.getColumnModel().getColumn(colIdx)).getColumnDisplayDefinition().getSqlType()) != 2005) continue;
            for (int rowIdx = firstSelectedRowIdx; rowIdx < lastSelectedRowIdx; ++rowIdx) {
                Object cellObj = this._table.getValueAt(rowIdx, colIdx);
                String data = DataExportCSVWriter.getDataCSV(sepChar, "" + cellObj);
                if (data == null || !ClobDescriptor.i18n.CLOB_LABEL.equals(data)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected IExportData createExportData(TableExportCsvController ctrl) {
        return new JTableExportData(this._table, ctrl.exportComplete());
    }
}

