/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.exportData;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataColumn;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataRow;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataCell;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataRow;

public class JTableExportData
implements IExportData {
    private JTable table;
    int nbrSelRows;
    int nbrSelCols;
    int[] selRows;
    int[] selCols;

    public JTableExportData(JTable table, boolean complete) {
        int i;
        this.table = table;
        this.nbrSelRows = table.getSelectedRowCount();
        if (0 == this.nbrSelRows || complete) {
            this.nbrSelRows = table.getRowCount();
        }
        this.nbrSelCols = table.getSelectedColumnCount();
        if (0 == this.nbrSelCols || complete) {
            this.nbrSelCols = table.getColumnCount();
        }
        this.selRows = table.getSelectedRows();
        if (0 == this.selRows.length || complete) {
            this.selRows = new int[this.nbrSelRows];
            for (i = 0; i < this.selRows.length; ++i) {
                this.selRows[i] = i;
            }
        }
        this.selCols = table.getSelectedColumns();
        if (0 == this.selCols.length || complete) {
            this.selCols = new int[this.nbrSelCols];
            for (i = 0; i < this.selCols.length; ++i) {
                this.selCols[i] = i;
            }
        }
    }

    @Override
    public Iterator<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (int colIdx = 0; colIdx < this.nbrSelCols; ++colIdx) {
            String columnName = this.table.getColumnName(this.selCols[colIdx]);
            headers.add(columnName);
        }
        return headers.iterator();
    }

    @Override
    public Iterator<IExportDataRow> getRows() {
        ArrayList<ExportDataRow> rows = new ArrayList<ExportDataRow>(this.nbrSelRows);
        for (int rowIdx = 0; rowIdx < this.nbrSelRows; ++rowIdx) {
            ArrayList<IExportDataCell> cells = new ArrayList<IExportDataCell>(this.nbrSelCols);
            for (int colIdx = 0; colIdx < this.nbrSelCols; ++colIdx) {
                ExportDataColumn cellObj;
                Object obj = this.table.getValueAt(this.selRows[rowIdx], this.selCols[colIdx]);
                if (this.table.getColumnModel().getColumn(colIdx) instanceof ExtTableColumn) {
                    ExtTableColumn col = (ExtTableColumn)this.table.getColumnModel().getColumn(this.selCols[colIdx]);
                    cellObj = new ExportDataColumn(col.getColumnDisplayDefinition(), obj, rowIdx, colIdx);
                } else {
                    cellObj = new ExportDataColumn(null, obj, rowIdx, colIdx);
                }
                cells.add(cellObj);
            }
            rows.add(new ExportDataRow(cells, rowIdx));
        }
        return rows.iterator();
    }
}

