/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.resources;

import java.util.Locale;
import java.util.ResourceBundle;

public class LazyResourceBundle {
    private static boolean _localeInitialized;
    private final String _bundleBaseName;
    private final ClassLoader _loader;
    private ResourceBundle _bundle;

    public LazyResourceBundle(String bundleBaseName, ClassLoader loader) {
        this._bundleBaseName = bundleBaseName;
        this._loader = loader;
    }

    public static void setLocaleInitialized() {
        _localeInitialized = true;
    }

    public String getString(String key) {
        if (!_localeInitialized) {
            throw new IllegalStateException("Must not create bundle before locale was initalized.");
        }
        if (null == this._bundle) {
            this._bundle = ResourceBundle.getBundle(this._bundleBaseName, Locale.getDefault(), this._loader);
        }
        return this._bundle.getString(key);
    }
}

