/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.SybaseASE;

import java.awt.event.ActionEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ScriptSybaseASEViewAction
extends SquirrelAction {
    private static final long serialVersionUID = 1L;
    private transient ISession _session;
    private final transient ILogger s_log = LoggerController.createLogger(ScriptSybaseASEViewAction.class);
    private static final String sql = "Select text from sysobjects inner join syscomments on syscomments.id = sysobjects.id where name = ?";

    public ScriptSybaseASEViewAction(IApplication app, Resources rsrc, ISession session) {
        super(app, (IResources)rsrc);
        this._session = session;
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            PreparedStatement stat = this._session.getSQLConnection().prepareStatement(sql);
            SessionInternalFrame sessMainFrm = this._session.getSessionInternalFrame();
            IDatabaseObjectInfo[] dbObjs = sessMainFrm.getObjectTreeAPI().getSelectedDatabaseObjects();
            StringBuffer script = new StringBuffer();
            for (int i = 0; i < dbObjs.length; ++i) {
                ITableInfo ti = (ITableInfo)dbObjs[i];
                stat.setString(1, ti.getSimpleName());
                if (this.s_log.isDebugEnabled()) {
                    this.s_log.debug((Object)"Running SQL: Select text from sysobjects inner join syscomments on syscomments.id = sysobjects.id where name = ?");
                    this.s_log.debug((Object)("Bind var value is: " + ti.getSimpleName()));
                }
                ResultSet res = stat.executeQuery();
                while (res.next()) {
                    script.append(res.getString("text"));
                }
                script.append(this.getStatementSeparator());
                res.close();
            }
            stat.close();
            sessMainFrm.getMainSQLPanelAPI().appendSQLScript(script.toString());
            sessMainFrm.getSessionPanel().selectMainTab(1);
        }
        catch (Exception e) {
            this.s_log.error((Object)("Unexpected exception while attempting to get source for view: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getStatementSeparator() {
        String statementSeparator = this._session.getQueryTokenizer().getSQLStatementSeparator();
        if (1 < statementSeparator.length()) {
            statementSeparator = "\n" + statementSeparator + "\n";
        }
        return statementSeparator;
    }
}

