/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.favs;

import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.IValidatable;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public final class Folder
implements Cloneable,
Serializable,
IHasIdentifier,
IValidatable {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(Folder.class);
    private static final String EMPTY_STRING = "";
    private IIdentifier _id;
    private String _name;
    private List<Folder> _subFolders = new ArrayList<Folder>();
    private transient PropertyChangeSupport _propChgNotifier = null;

    public Folder() {
        this(IdentifierFactory.getInstance().createIdentifier(), EMPTY_STRING);
    }

    public Folder(IIdentifier id, String name) {
        this._id = id != null ? id : IdentifierFactory.getInstance().createIdentifier();
        this._name = this.getString(name);
    }

    public boolean equals(Object rhs) {
        boolean rc = false;
        if (rhs != null && rhs.getClass().equals(this.getClass())) {
            rc = ((Folder)rhs).getIdentifier().equals((Object)this.getIdentifier());
        }
        return rc;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public synchronized int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public synchronized boolean isValid() {
        return this._name.trim().length() > 0;
    }

    public IIdentifier getIdentifier() {
        return this._id;
    }

    public void setIdentifier(IIdentifier id) {
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) throws ValidationException {
        String data = this.getString(name);
        if (data.length() == 0) {
            throw new ValidationException(i18n.ERR_BLANK_NAME);
        }
        if (this._name != data) {
            String oldValue = this._name;
            this._name = data;
            this.getPropertyChangeNotifier().firePropertyChange("Name", oldValue, this._name);
        }
    }

    public void addSubFolder(Folder subFolder) throws IllegalArgumentException {
        if (subFolder == null) {
            throw new IllegalArgumentException("Null Folder passed");
        }
        this._subFolders.add(subFolder);
    }

    public boolean removeSubFolder(Folder subFolder) throws IllegalArgumentException {
        if (subFolder == null) {
            throw new IllegalArgumentException("Null Folder passed");
        }
        return this._subFolders.remove(subFolder);
    }

    public Iterator<Folder> subFolders() {
        return this._subFolders.iterator();
    }

    public Folder[] getSubFolders() {
        return this._subFolders.toArray(new Folder[this._subFolders.size()]);
    }

    public Folder getSubFolder(int idx) throws ArrayIndexOutOfBoundsException {
        return this._subFolders.get(idx);
    }

    public void setSubFolders(Folder[] value) {
        this._subFolders.clear();
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                this._subFolders.add(value[i]);
            }
        }
    }

    public void setSubFolder(int idx, Folder value) throws ArrayIndexOutOfBoundsException {
        this._subFolders.set(idx, value);
    }

    private PropertyChangeSupport getPropertyChangeNotifier() {
        if (this._propChgNotifier == null) {
            this._propChgNotifier = new PropertyChangeSupport(this);
        }
        return this._propChgNotifier;
    }

    private String getString(String data) {
        return data != null ? data.trim() : EMPTY_STRING;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    public static interface IPropertyNames {
        public static final String ID = "Identifier";
        public static final String NAME = "Name";
        public static final String SUB_FOLDERS = "SubFolders";
    }

    private static interface i18n {
        public static final String ERR_BLANK_NAME = Folder.access$000().getString("favs.nameMustNotBeBlank");
    }
}

