/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.favs;

import java.io.Serializable;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.IValidatable;

final class Query
implements Cloneable,
Serializable,
IHasIdentifier,
IValidatable {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_STRING = "";
    private IIdentifier _id;
    private String _name;
    private String _description;
    private String _sql;

    public Query() {
        this(IdentifierFactory.getInstance().createIdentifier(), EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
    }

    public Query(IIdentifier id, String name, String description, String sql) {
        this._id = id != null ? id : IdentifierFactory.getInstance().createIdentifier();
        this._name = this.getString(name);
        this._description = this.getString(description);
        this._sql = this.getString(sql);
    }

    public boolean equals(Object rhs) {
        boolean rc = false;
        if (rhs != null && rhs.getClass().equals(this.getClass())) {
            rc = ((Query)rhs).getIdentifier().equals((Object)this.getIdentifier());
        }
        return rc;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public synchronized int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public synchronized boolean isValid() {
        return this._name.trim().length() > 0 && this._sql.trim().length() > 0;
    }

    public IIdentifier getIdentifier() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    private String getString(String data) {
        return data != null ? data.trim() : EMPTY_STRING;
    }

    public static interface IPropertyNames {
        public static final String DESCRIPTION = "Description";
        public static final String ID = "Identifier";
        public static final String NAME = "Name";
        public static final String SQL = "Sql";
    }
}

