/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.commands;

import java.awt.Frame;
import java.sql.SQLException;
import java.util.List;
import net.sourceforge.squirrel_sql.client.gui.IProgressCallBackFactory;
import net.sourceforge.squirrel_sql.client.gui.ProgressCallBackFactory;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.DBCopyPlugin;
import net.sourceforge.squirrel_sql.plugins.dbcopy.util.DBUtil;

public class CopyTableCommand
implements ICommand {
    private ISession _session;
    private final DBCopyPlugin _plugin;
    private static final ILogger log = LoggerController.createLogger(CopyTableCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CopyTableCommand.class);
    private IProgressCallBackFactory progressCallBackFactory = new ProgressCallBackFactory();

    public CopyTableCommand(ISession session, DBCopyPlugin plugin) {
        this._session = session;
        this._plugin = plugin;
    }

    public void setProgressCallBackFactory(IProgressCallBackFactory progressCallBackFactory) {
        this.progressCallBackFactory = progressCallBackFactory;
    }

    public void execute() {
        IObjectTreeAPI api = this._session.getObjectTreeAPIOfActiveSessionWindow();
        if (api != null) {
            IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
            if (DatabaseObjectType.TABLE_TYPE_DBO.equals(dbObjs[0].getDatabaseObjectType())) {
                String catalog = dbObjs[0].getCatalogName();
                String schema = dbObjs[0].getSchemaName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CopyTableCommand.execute: catalog=" + catalog));
                    log.debug((Object)("CopyTableCommand.execute: schema=" + schema));
                }
                dbObjs = DBUtil.getTables(this._session, catalog, schema, null);
                for (int i = 0; i < dbObjs.length; ++i) {
                    ITableInfo info = (ITableInfo)dbObjs[i];
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("dbObj[" + i + "] = " + info.getSimpleName()));
                }
            }
            this._plugin.getSessionInfoProvider().initCopy(this._session);
            final IDatabaseObjectInfo[] fdbObjs = dbObjs;
            final SQLDatabaseMetaData md = this._session.getSQLConnection().getSQLMetaData();
            this._session.getApplication().getThreadPool().addTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        CopyTableCommand.this.getInsertionOrder(fdbObjs, md);
                        CopyTableCommand.this._plugin.setPasteMenuEnabled(true);
                    }
                    catch (SQLException e) {
                        log.error((Object)"Unexected exception: ", (Throwable)e);
                    }
                }
            });
        }
    }

    private void getInsertionOrder(IDatabaseObjectInfo[] dbObjs, SQLDatabaseMetaData md) throws SQLException {
        List selectedTables = DBUtil.convertObjectArrayToTableList(dbObjs);
        if (selectedTables.size() > 1) {
            ProgressCallBack cb = this.progressCallBackFactory.create((Frame)this._session.getApplication().getMainFrame(), i18n.PROGRESS_DIALOG_TITLE, dbObjs.length);
            cb.setLoadingPrefix(i18n.LOADING_PREFIX);
            selectedTables = SQLUtilities.getInsertionOrder(selectedTables, (SQLDatabaseMetaData)md, (ProgressCallBack)cb);
            cb.setVisible(false);
            cb.dispose();
            this._plugin.getSessionInfoProvider().setSourceDatabaseObjects(DBUtil.convertTableToObjectList(selectedTables));
        } else {
            this._plugin.getSessionInfoProvider().setSourceDatabaseObjects(DBUtil.convertTableToObjectList(selectedTables));
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String PROGRESS_DIALOG_TITLE = CopyTableCommand.access$000().getString("CopyTablesCommand.progressDialogTitle");
        public static final String LOADING_PREFIX = CopyTableCommand.access$000().getString("CopyTablesCommand.loadingPrefix");
    }
}

