/*
 * Decompiled with CFR 0.152.
 */
package net.steppschuh.markdowngenerator;

import net.steppschuh.markdowngenerator.MarkdownSerializable;
import net.steppschuh.markdowngenerator.MarkdownSerializationException;

public abstract class MarkdownElement
implements MarkdownSerializable {
    private String serialized;

    public abstract String serialize() throws MarkdownSerializationException;

    public String getSerialized(String fallback) {
        try {
            return this.getSerialized();
        }
        catch (MarkdownSerializationException e) {
            return fallback;
        }
    }

    public String getSerialized() throws MarkdownSerializationException {
        if (this.serialized == null) {
            this.serialized = this.serialize();
        }
        return this.serialized;
    }

    public void setSerialized(String serialized) {
        this.serialized = serialized;
    }

    public void invalidateSerialized() {
        this.setSerialized(null);
    }

    @Override
    public MarkdownElement toMarkdownElement() throws MarkdownSerializationException {
        return this;
    }

    public String toString() {
        return this.getSerialized(this.getClass().getSimpleName());
    }
}

