/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.completion;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.AliasFinderListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.AliasInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.HqlAliasParser;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.MappingInfoProvider;

public class HQLAliasFinder {
    private static ILogger s_log = LoggerController.createLogger(HQLAliasFinder.class);
    private MappingInfoProvider _mappingInfoProvider;
    private ISQLEntryPanel _hqlEntryPanel;
    private AliasFinderListener _aliasFinderListener;
    private Timer _timer;
    private HqlAliasParser _hqlAliasParser = new HqlAliasParser();

    public HQLAliasFinder(ISQLEntryPanel hqlEntryPanel) {
        this._hqlEntryPanel = hqlEntryPanel;
    }

    public void start(MappingInfoProvider mappingInfoProvider, AliasFinderListener aliasFinderListener) {
        if (null == this._timer) {
            this._mappingInfoProvider = mappingInfoProvider;
            this._aliasFinderListener = aliasFinderListener;
            this.findAliases();
            this.start();
        }
    }

    private void start() {
        this._timer = new Timer();
        this._timer.schedule(new TimerTask(){

            @Override
            public void run() {
                HQLAliasFinder.this.findAliases();
            }
        }, 1000L, 1000L);
    }

    public void stop() {
        if (null != this._timer) {
            this._timer.cancel();
            this._timer.purge();
            this._timer = null;
        }
    }

    private void findAliases() {
        try {
            String hql = this._hqlEntryPanel.getText();
            final ArrayList<AliasInfo> infos = this.parse(hql);
            GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    HQLAliasFinder.this._aliasFinderListener.aliasesFound(infos);
                }
            });
        }
        catch (Throwable t) {
            s_log.error((Object)"Error in HQLAliasFinder:", t);
        }
    }

    private ArrayList<AliasInfo> parse(String hql) {
        return this._hqlAliasParser.parse(hql, this._mappingInfoProvider);
    }
}

