/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.Serializable;
import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;
import unity.query.LQNode;
import unity.query.SubQuery;
import unity.util.StringFunc;

public abstract class Operator
implements Serializable {
    private static final long serialVersionUID = -7339525487884723365L;
    protected Operator[] input;
    protected int numInputs;
    protected Relation outputRelation;
    protected LQNode queryNode;
    protected long MEMORY_SIZE_IN_BYTES;
    protected long rowsOut;
    protected long IOBytes;
    protected SubQuery subquery;

    public Operator() {
        this(null, 0L);
    }

    public Operator(Operator[] operatorArray, long l) {
        this.numInputs = operatorArray == null ? 0 : operatorArray.length;
        this.input = operatorArray;
        this.MEMORY_SIZE_IN_BYTES = l;
        this.rowsOut = 0L;
        this.IOBytes = 0L;
    }

    public abstract void init() throws SQLException;

    public abstract boolean next(Tuple var1) throws SQLException;

    public void close() throws SQLException {
        for (int i = 0; i < this.numInputs; ++i) {
            this.input[i].close();
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Operation: " + this.toString() + " Rows output: " + this.rowsOut + " IO bytes: " + this.IOBytes);
        }
    }

    public void setOutputRelation(Relation relation) {
        this.outputRelation = relation;
    }

    public Relation getOutputRelation() {
        return this.outputRelation;
    }

    public int getRowSize() {
        if (this.outputRelation == null) {
            return 0;
        }
        return this.outputRelation.calculateSize();
    }

    protected void incrementRowsOut() {
        ++this.rowsOut;
    }

    protected void incrementRowsOut(int n) {
        this.rowsOut += (long)n;
    }

    protected void incrementIOBytes(long l) {
        this.IOBytes += l;
    }

    public long getRowsOutput() {
        return this.rowsOut;
    }

    public long getIOBytes() {
        return this.IOBytes;
    }

    public Operator getChild(int n) {
        return this.input[n];
    }

    public int numChildren() {
        return this.numInputs;
    }

    public static void printTree(Operator operator, int n) {
        if (operator == null) {
            return;
        }
        System.out.println(StringFunc.spaces(n * 3) + operator.toString());
        if (operator.input == null) {
            return;
        }
        int n2 = n + 1;
        for (int i = 0; i < operator.input.length; ++i) {
            Operator.printTree(operator.input[i], n2);
        }
    }

    public String getSource() {
        if (this.queryNode != null) {
            return this.queryNode.getDatabase().getName();
        }
        return null;
    }

    public double getCost() {
        if (this.queryNode != null) {
            return this.queryNode.getCost();
        }
        return 0.0;
    }

    public double getIO() {
        if (this.queryNode != null) {
            return this.queryNode.getIO();
        }
        return 0.0;
    }

    public long getRows() {
        if (this.queryNode != null) {
            return this.queryNode.getRows();
        }
        return 0L;
    }

    public abstract String getName();

    public abstract String getDescription();

    public LQNode getQueryNode() {
        return this.queryNode;
    }

    public SubQuery getSubquery() {
        return this.subquery;
    }

    public void setSubquery(SubQuery subQuery) {
        this.subquery = subQuery;
    }
}

