/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.graphtofiles;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.ExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.graphtofiles.GraphToFilesDlg;

public class GraphToFilesCtrlr {
    GraphToFilesDlg _dlg;
    private static final String PREF_KEY_LAST_IMAGE_DIR = "SquirrelSQL.graph.lastImageDir";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphToFilesCtrlr.class);
    private BufferedImage[] _images;
    private Window _parent;

    public GraphToFilesCtrlr(BufferedImage[] images, Window parent) {
        this._images = images;
        this._parent = parent;
        this._dlg = new GraphToFilesDlg(parent, images);
        this._dlg.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphToFilesCtrlr.this.onClosing();
                GraphToFilesCtrlr.this._dlg.setVisible(false);
                GraphToFilesCtrlr.this._dlg.dispose();
            }
        });
        this._dlg.btnSaveToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphToFilesCtrlr.this.onSaveToFile();
            }
        });
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GraphToFilesCtrlr.this.onClosing();
            }
        });
    }

    private void onClosing() {
        for (int i = 0; i < this._images.length; ++i) {
            this._images[i].flush();
        }
    }

    private void onSaveToFile() {
        try {
            File selectedFile;
            String lastDir = Props.getString((String)PREF_KEY_LAST_IMAGE_DIR, (String)System.getProperty("user.home"));
            JFileChooser fc = new JFileChooser(lastDir);
            fc.setDialogTitle(s_stringMgr.getString("graphToFile.fileChooserTitle"));
            if (1 < this._images.length) {
                fc.setFileSelectionMode(1);
            } else {
                fc.setFileSelectionMode(0);
                ExtensionFilter ef = new ExtensionFilter();
                ef.addExtension(s_stringMgr.getString("graphToFile.ImageFileSpec"), "jpg");
                fc.setFileFilter((FileFilter)ef);
            }
            if (fc.showSaveDialog(this._parent) == 0 && null != (selectedFile = fc.getSelectedFile())) {
                if (1 == this._images.length) {
                    if (!selectedFile.getPath().toUpperCase().endsWith(".JPG")) {
                        selectedFile = new File(selectedFile.getPath() + ".jpg");
                    }
                    ImageIO.write((RenderedImage)this._images[0], "jpg", selectedFile);
                    Props.putString((String)PREF_KEY_LAST_IMAGE_DIR, (String)selectedFile.getParent());
                } else {
                    selectedFile.mkdirs();
                    for (int i = 0; i < this._images.length; ++i) {
                        File f = new File(selectedFile, "Page_" + (i + 1) + ".jpg");
                        ImageIO.write((RenderedImage)this._images[i], "jpg", f);
                    }
                    Props.putString((String)PREF_KEY_LAST_IMAGE_DIR, (String)selectedFile.getPath());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

