
// automatically generated by m4 from headers in proto subdir


#ifndef __NIRVANA_PLUS_H__
#define __NIRVANA_PLUS_H__

#include <intrinsic.h>

/* ----------------------------------------------------------------
 * Z88DK INTERFACE LIBRARY FOR NIRVANA+ ENGINE - by Einar Saukas
 *
 * If you use this interface library, you must load afterwards the
 * NIRVANA+ ENGINE and a bicolor tile set. For a detailed sample
 * see file "nirvanadem.c".
 * ----------------------------------------------------------------
 */

#ifndef NIRVANAP_TOTAL_ROWS
#define NIRVANAP_TOTAL_ROWS 23
#endif

// ----------------------------------------------------------------
// Activate NIRVANA ENGINE
// ----------------------------------------------------------------

extern void NIRVANAP_start(void) __preserves_regs(b,c,d,e,h,l);


// ----------------------------------------------------------------
// Deactivate NIRVANA ENGINE
// ----------------------------------------------------------------

extern void NIRVANAP_stop(void) __preserves_regs(b,c,d,e,h,l);


// ----------------------------------------------------------------
// Execute HALT (wait for next frame).
//
// If an interrupt occurs while certain routines are under execution
// the program may crash (routines NIRVANAP_fillT, NIRVANAP_drawT and
// NIRVANAP_drawW), or a sprite may be displayed at an incorrect
// location (routine NIRVANAP_spriteT).
//
// Routine NIRVANAP_halt can be used to avoid these problems.
// Immediately after calling it, your program will have some time
// (about 12.5K T) to execute a few other routines without any
// interruption.
// ----------------------------------------------------------------

#define NIRVANAP_halt()  intrinsic_halt()

// ----------------------------------------------------------------
// Location of NIRVANA ISR hook
// ----------------------------------------------------------------

#ifdef __CLANG
   static unsigned char NIRVANAP_isr[3];
#endif

#ifdef __SDCC
   __at (56698+328*NIRVANAP_TOTAL_ROWS) static unsigned char NIRVANAP_isr[3];
#endif

#ifdef __SCCZ80
//   static unsigned char NIRVANAP_isr[3] @ (56698+328*NIRVANAP_TOTAL_ROWS);
#endif

// ----------------------------------------------------------------
// Instantly draw tile (16x16 pixels) at specified position
//
// Parameters:
//     tile: tile index (0-255)
//     lin: pixel line (0-200, even values only)
//     col: char column (0-30)
//
// WARNING: If this routine is under execution when interrupt
//          occurs, program may crash!!! (see NIRVANAP_halt)
// ----------------------------------------------------------------

extern void NIRVANAP_drawT(unsigned char tile,unsigned char lin,unsigned char col);
extern void NIRVANAP_drawT_callee(unsigned char tile,unsigned char lin,unsigned char col) __z88dk_callee;
#define NIRVANAP_drawT(a,b,c) NIRVANAP_drawT_callee(a,b,c)


extern void NIRVANAP_drawT_raw(unsigned char tile,unsigned char lin,unsigned char col);
extern void NIRVANAP_drawT_raw_callee(unsigned char tile,unsigned char lin,unsigned char col) __z88dk_callee;
#define NIRVANAP_drawT_raw(a,b,c) NIRVANAP_drawT_raw_callee(a,b,c)



// ----------------------------------------------------------------
// Instantly change the attributes in a tile area (16x16 pixels) to
// the specified value (use the same INK and PAPER values to "erase"
// a tile)
//
// Parameters:
//     attr: attribute value (0-255), INK+8*PAPER+64*BRIGHT+128*FLASH
//     lin: pixel line (0-200, even values only)
//     col: char column (0-30)
//
// WARNING: If this routine is under execution when interrupt
//          occurs, program may crash!!! (see NIRVANAhalt)
// ----------------------------------------------------------------

extern void NIRVANAP_fillT(unsigned char attr,unsigned char lin,unsigned char col);
extern void NIRVANAP_fillT_callee(unsigned char attr,unsigned char lin,unsigned char col) __z88dk_callee;
#define NIRVANAP_fillT(a,b,c) NIRVANAP_fillT_callee(a,b,c)


extern void NIRVANAP_fillT_raw(unsigned char attr,unsigned char lin,unsigned char col);
extern void NIRVANAP_fillT_raw_callee(unsigned char attr,unsigned char lin,unsigned char col) __z88dk_callee;
#define NIRVANAP_fillT_raw(a,b,c) NIRVANAP_fillT_raw_callee(a,b,c)



// ----------------------------------------------------------------
// Instantly print a 8x8 character at specified position, afterwards
// paint it with a provided sequence of 4 attribute values.
//
// Parameters:
//     ch: character code (0-255)
//     attrs: attributes address
//     lin: pixel line (16-192, even values only)
//     col: char column (0-31)
// ----------------------------------------------------------------

extern void NIRVANAP_printC(unsigned char ch,void *attrs,unsigned char lin,unsigned char col);
extern void NIRVANAP_printC_callee(unsigned char ch,void *attrs,unsigned char lin,unsigned char col) __z88dk_callee;
#define NIRVANAP_printC(a,b,c,d) NIRVANAP_printC_callee(a,b,c,d)



// ----------------------------------------------------------------
// Instantly paint a 8x8 character at specified position with a
// provided sequence of 4 attribute values.
//
// Parameters:
//     attrs: attributes address
//     lin: pixel line (16-192, even values only)
//     col: char column (0-31)
// ----------------------------------------------------------------

extern void NIRVANAP_paintC(void *attrs,unsigned char lin,unsigned char col);
extern void NIRVANAP_paintC_callee(void *attrs,unsigned char lin,unsigned char col) __z88dk_callee;
#define NIRVANAP_paintC(a,b,c) NIRVANAP_paintC_callee(a,b,c)



// ----------------------------------------------------------------
// Instantly change attributes in 8x8 character area to the
// specified value (use the same INK and PAPER values to "erase" a
// character).
//
// Parameters:
//     attr: attribute value (0-255), INK+8*PAPER+64*BRIGHT+128*FLASH
//     lin: pixel line (16-192, even values only)
//     col: char column (0-31)
// ----------------------------------------------------------------

extern void NIRVANAP_fillC(unsigned char attr,unsigned char lin,unsigned char col) __preserves_regs(b);
extern void NIRVANAP_fillC_callee(unsigned char attr,unsigned char lin,unsigned char col) __preserves_regs(b) __z88dk_callee;
#define NIRVANAP_fillC(a,b,c) NIRVANAP_fillC_callee(a,b,c)



// ----------------------------------------------------------------
// Update sprite information, so the specified tile will automatically
// appear at the specified location when the next interrupt occurs
// (and automatically redrawn at every interrupt afterwards, until
// this sprite information is updated again).
//
// Sprites are displayed in increasing priority order, i.e.
// sprite 7 will appear in front of everything else.
//
// Notice there's no way to disable sprites. If you don't want to
// display a certain sprite, simply move it to line zero, so it
// will be hidden outside the screen.
//
// Parameters:
//     sprite: sprite number (0-7)
//     tile: tile index (0-255)
//     lin: pixel line (0-200, even values only)
//     col: char column (0-30)
//
// WARNING: If this routine is under execution when interrupt occurs,
//          a sprite (containing partially updated information) may
//          be displayed at an incorrect location on screen (see
//          NIRVANAhalt)
// ----------------------------------------------------------------

extern void NIRVANAP_spriteT(unsigned char sprite,unsigned char tile,unsigned char lin,unsigned char col);
extern void NIRVANAP_spriteT_callee(unsigned char sprite,unsigned char tile,unsigned char lin,unsigned char col) __z88dk_callee;
#define NIRVANAP_spriteT(a,b,c,d) NIRVANAP_spriteT_callee(a,b,c,d)



// ----------------------------------------------------------------
// Instantly draw wide tile (24x16 pixels) at specified position
//
// Parameters:
//     tile: wide tile index (0-255)
//     lin: pixel line (0-200, even values only)
//     col: char column (0-29)
//
// WARNING: If this routine is under execution when interrupt
//          occurs, program may crash!!! (see NIRVANAhalt)
//
// WARNING: Only use this routine if NIRVANA_drawW was enabled!!!
// ----------------------------------------------------------------

extern void NIRVANAP_drawW(unsigned char tile,unsigned char lin,unsigned char col);
extern void NIRVANAP_drawW_callee(unsigned char tile,unsigned char lin,unsigned char col) __z88dk_callee;
#define NIRVANAP_drawW(a,b,c) NIRVANAP_drawW_callee(a,b,c)


extern void NIRVANAP_drawW_raw(unsigned char tile,unsigned char lin,unsigned char col);
extern void NIRVANAP_drawW_raw_callee(unsigned char tile,unsigned char lin,unsigned char col) __z88dk_callee;
#define NIRVANAP_drawW_raw(a,b,c) NIRVANAP_drawW_raw_callee(a,b,c)



// ----------------------------------------------------------------
// Reconfigure NIRVANA ENGINE to read bicolor tiles (16x16 pixels)
// from another address (default value is 48000).
//
// Parameters:
//     addr: New tile images address
// ----------------------------------------------------------------

extern void NIRVANAP_tiles(void *addr) __preserves_regs(b,c,d,e);
extern void NIRVANAP_tiles_fastcall(void *addr) __preserves_regs(a,b,c,d,e) __z88dk_fastcall;
#define NIRVANAP_tiles(a) NIRVANAP_tiles_fastcall(a)



// ----------------------------------------------------------------
// Reconfigure NIRVANA ENGINE to read wide bicolor tiles (24x16
// pixels) from another address (default value is 54000).
//
// Parameters:
//     addr: New wide tile images address
//
// WARNING: Only use this routine if NIRVANAP_drawW was enabled!!!
// ----------------------------------------------------------------

extern void NIRVANAP_wides(void *addr) __preserves_regs(b,c,d,e);
extern void NIRVANAP_wides_fastcall(void *addr) __preserves_regs(a,b,c,d,e) __z88dk_fastcall;
#define NIRVANAP_wides(a) NIRVANAP_wides_fastcall(a)



// ----------------------------------------------------------------
// Reconfigure NIRVANA ENGINE to read character table from another
// address (default value is 15360 that corresponds to the standard
// ROM character table).
//
// Parameters:
//     addr: New character table address
// ----------------------------------------------------------------

extern void NIRVANAP_chars(void *addr) __preserves_regs(b,c,d,e);
extern void NIRVANAP_chars_fastcall(void *addr) __preserves_regs(a,b,c,d,e) __z88dk_fastcall;
#define NIRVANAP_chars(a) NIRVANAP_chars_fastcall(a)



// ----------------------------------------------------------------
// Advanced conversions
// ----------------------------------------------------------------

#define ROW2LIN(row)            (((row)+1)<<3)
#define LIN2ROW_UP(lin)         (((lin)>>3)-1)
#define LIN2ROW_DOWN(lin)       (((lin)-1)>>3)

#define SPRITECOL(sprite)       ((unsigned char *)56469+((sprite)<<3))
#define SPRITELIN(sprite)       ((unsigned char *)56470+((sprite)<<3))
#define SPRITEVAL(sprite)       ((unsigned char *)56472+((sprite)<<3))

#endif
