
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; target library constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;; cpm bdos functions
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   
   PUBLIC __CPM_RCON, __CPM_WCON, __CPM_RRDR, __CPM_WPUN
   PUBLIC __CPM_WLST, __CPM_DCIO, __CPM_GIOB, __CPM_SIOB
   PUBLIC __CPM_RCOB, __CPM_ICON, __CPM_VERS, __CPM_RDS
   PUBLIC __CPM_LGIN, __CPM_OPN, __CPM_CLS, __CPM_FFST
   PUBLIC __CPM_FNXT, __CPM_DEL, __CPM_READ, __CPM_WRIT
   PUBLIC __CPM_MAKE, __CPM_REN, __CPM_ILOG, __CPM_IDRV
   PUBLIC __CPM_SDMA, __CPM_SUID, __CPM_RRAN, __CPM_CFS
   PUBLIC __CPM_DSEG
   
   defc __CPM_RCON = 1               ; read console
   defc __CPM_WCON = 2               ; write console
   defc __CPM_RRDR = 3               ; read reader
   defc __CPM_WPUN = 4               ; write punch
   defc __CPM_WLST = 5               ; write list
   defc __CPM_DCIO = 6               ; direct console I/O
   defc __CPM_GIOB = 7               ; get I/O byte
   defc __CPM_SIOB = 8               ; set I/O byte
   defc __CPM_PRST = 9               ; print string
   defc __CPM_RCOB = 10              ; read console buffered
   defc __CPM_ICON = 11              ; interrogate console ready
   defc __CPM_VERS = 12              ; return version number
   defc __CPM_RDS  = 13              ; reset disk system
   defc __CPM_LGIN = 14              ; log in and select disk
   defc __CPM_OPN  = 15              ; open file
   defc __CPM_CLS  = 16              ; close file
   defc __CPM_FFST = 17              ; find first
   defc __CPM_FNXT = 18              ; find next
   defc __CPM_DEL  = 19              ; delete file
   defc __CPM_READ = 20              ; read next record
   defc __CPM_WRIT = 21              ; write next record
   defc __CPM_MAKE = 22              ; create file
   defc __CPM_REN  = 23              ; rename file
   defc __CPM_ILOG = 24              ; get bit map of logged in disks
   defc __CPM_IDRV = 25              ; interrogate drive number
   defc __CPM_SDMA = 26              ; set DMA address for i/o
   defc __CPM_SUID = 32              ; set/get user id
   defc __CPM_RRAN = 33              ; read random record
   defc __CPM_WRAN = 34              ; write random record
   defc __CPM_CFS  = 35              ; compute file size
   defc __CPM_DSEG = 51              ; set DMA segment

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;; target error
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;; target messages
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;; target ioctls
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;      
   
;; end target library constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
