/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractMergeAction
extends JosmAction {
    public AbstractMergeAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        super(string, string2, string3, shortcut, bl);
    }

    public AbstractMergeAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4, boolean bl2) {
        super(string, string2, string3, shortcut, bl, string4, bl2);
    }

    protected static Layer askTargetLayer(List<Layer> list) {
        return AbstractMergeAction.askTargetLayer((Layer[])list.toArray(new Layer[list.size()]), (String)I18n.tr("Please select the target layer.", new Object[0]), (String)I18n.tr("Select target layer", new Object[0]), (String)I18n.tr("Merge", new Object[0]), (String)"dialogs/mergedown");
    }

    public static <T extends Layer> T askTargetLayer(T[] TArray, String string, String string2, String string3, String string4) {
        JosmComboBox<T> josmComboBox = new JosmComboBox<T>(TArray);
        josmComboBox.setRenderer(new LayerListCellRenderer());
        josmComboBox.setSelectedIndex(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(string), GBC.eol());
        jPanel.add(josmComboBox, GBC.eol());
        if (GraphicsEnvironment.isHeadless()) {
            return TArray[0];
        }
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string2, string3, I18n.tr("Cancel", new Object[0]));
        extendedDialog.setButtonIcons(string4, "cancel");
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return null;
        }
        return (T)((Layer)josmComboBox.getSelectedItem());
    }

    protected void warnNoTargetLayersForSourceLayer(Layer layer) {
        String string = I18n.tr("<html>There are no layers the source layer<br>''{0}''<br>could be merged to.</html>", Utils.escapeReservedCharactersHTML(layer.getName()));
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("No target layers", new Object[0]), 2);
        }
    }

    public static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            Layer layer = (Layer)object;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, layer.getName(), n, bl, bl2);
            jLabel.setIcon(layer.getIcon());
            jLabel.setToolTipText(layer.getToolTipText());
            return jLabel;
        }
    }
}

