/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.preferences.StringSetting;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class StringEditor
extends ExtendedDialog {
    private final transient PrefEntry entry;
    private JosmTextField tvalue;

    public StringEditor(JComponent jComponent, PrefEntry prefEntry, StringSetting stringSetting) {
        super((Component)jComponent, I18n.tr("Change string setting", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.entry = prefEntry;
        this.setButtonIcons("ok", "cancel");
        this.setContent(this.build(stringSetting.getValue() == null ? "" : (String)stringSetting.getValue()));
    }

    public String getData() {
        return this.tvalue.getText();
    }

    protected final JPanel build(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key: {0}", this.entry.getKey())), GBC.eol().insets(0, 0, 5, 0));
        jPanel.add((Component)new JLabel(I18n.tr("Value: ", new Object[0])), GBC.std());
        this.tvalue = new JosmTextField(string, 50);
        jPanel.add((Component)this.tvalue, GBC.eop().insets(5, 0, 0, 0).fill(2));
        return jPanel;
    }
}

