/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.tools.I18n;

public class RemoteControlHttpServer
extends Thread {
    private final ServerSocket server;
    private static volatile RemoteControlHttpServer instance4;
    private static volatile RemoteControlHttpServer instance6;

    public static void restartRemoteControlHttpServer() {
        block4: {
            RemoteControlHttpServer.stopRemoteControlHttpServer();
            int n = Main.pref.getInteger("remote.control.port", 8111);
            try {
                instance4 = new RemoteControlHttpServer(n, false);
                instance4.start();
            }
            catch (IOException iOException) {
                Main.debug(iOException);
                Main.warn(I18n.marktr("Cannot start IPv4 remotecontrol server on port {0}: {1}"), Integer.toString(n), iOException.getLocalizedMessage());
            }
            try {
                instance6 = new RemoteControlHttpServer(n, true);
                instance6.start();
            }
            catch (IOException iOException) {
                if (instance4 != null) break block4;
                Main.debug(iOException);
                Main.warn(I18n.marktr("Cannot start IPv6 remotecontrol server on port {0}: {1}"), Integer.toString(n), iOException.getLocalizedMessage());
            }
        }
    }

    public static void stopRemoteControlHttpServer() {
        if (instance4 != null) {
            try {
                instance4.stopServer();
            }
            catch (IOException iOException) {
                Main.error(iOException);
            }
            instance4 = null;
        }
        if (instance6 != null) {
            try {
                instance6.stopServer();
            }
            catch (IOException iOException) {
                Main.error(iOException);
            }
            instance6 = null;
        }
    }

    public RemoteControlHttpServer(int n, boolean bl) throws IOException {
        super("RemoteControl HTTP Server");
        this.setDaemon(true);
        this.server = new ServerSocket(n, 1, bl ? RemoteControl.getInet6Address() : RemoteControl.getInet4Address());
    }

    @Override
    public void run() {
        Main.info(I18n.marktr("RemoteControl::Accepting remote connections on {0}:{1}"), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    RequestProcessor.processRequest(socket);
                }
            }
            catch (SocketException socketException) {
                if (!this.server.isClosed()) {
                    Main.error(socketException);
                    continue;
                }
                return;
            }
            catch (IOException iOException) {
                Main.error(iOException);
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        Main.info(I18n.marktr("RemoteControl::Server {0}:{1} stopped."), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        this.server.close();
    }
}

