/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.sgi;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.sgi.RLEDecoder;
import com.twelvemonkeys.imageio.plugins.sgi.SGIHeader;
import com.twelvemonkeys.imageio.plugins.sgi.SGIMetadata;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.xml.XMLSerializer;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class SGIImageReader
extends ImageReaderBase {
    private SGIHeader header;

    protected SGIImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.header = null;
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getWidth();
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getHeight();
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        int n2 = this.header.getChannels();
        ColorSpace colorSpace = n2 < 3 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
        switch (this.header.getBytesPerPixel()) {
            case 1: {
                return ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])this.createIndices(n2, 1), (int[])this.createIndices(n2, 0), (int)0, (n2 == 2 || n2 == 4 ? 1 : 0) != 0, (boolean)false);
            }
            case 2: {
                return ImageTypeSpecifiers.createBanded((ColorSpace)colorSpace, (int[])this.createIndices(n2, 1), (int[])this.createIndices(n2, 0), (int)1, (n2 == 2 || n2 == 4 ? 1 : 0) != 0, (boolean)false);
            }
        }
        throw new IIOException("Unknown number of bytes per pixel: " + this.header.getBytesPerPixel());
    }

    private int[] createIndices(int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i * n2;
        }
        return nArray;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int[] nArray;
        int[] nArray2;
        Iterator<ImageTypeSpecifier> iterator = this.getImageTypes(n);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        if (this.header.getColorMode() != 0) {
            this.processWarningOccurred(String.format("Unsupported color mode: %d, colors may look incorrect", this.header.getColorMode()));
        }
        int n2 = this.getWidth(n);
        int n3 = this.getHeight(n);
        BufferedImage bufferedImage = SGIImageReader.getDestination((ImageReadParam)imageReadParam, iterator, (int)n2, (int)n3);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        SGIImageReader.computeRegions((ImageReadParam)imageReadParam, (int)n2, (int)n3, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        WritableRaster writableRaster = this.clipToRect(bufferedImage.getRaster(), rectangle2, imageReadParam != null ? imageReadParam.getDestinationBands() : null);
        SGIImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)imageTypeSpecifier.getNumBands(), (int)writableRaster.getNumBands());
        WritableRaster writableRaster2 = imageTypeSpecifier.createBufferedImage(n2, 1).getRaster();
        Raster raster = this.clipRowToRect(writableRaster2, rectangle, imageReadParam != null ? imageReadParam.getSourceBands() : null, imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1);
        int n4 = this.header.getCompression();
        if (n4 == 1) {
            nArray2 = new int[n3 * this.header.getChannels()];
            nArray = new int[n3 * this.header.getChannels()];
            this.imageInput.readFully(nArray2, 0, nArray2.length);
            this.imageInput.readFully(nArray, 0, nArray.length);
        } else {
            nArray2 = null;
            nArray = null;
        }
        int n5 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        int n6 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        this.processImageStarted(n);
        for (int i = 0; i < this.header.getChannels(); ++i) {
            WritableRaster writableRaster3 = writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, new int[]{i});
            Raster raster2 = raster.createChild(raster.getMinX(), 0, raster.getWidth(), 1, 0, 0, new int[]{i});
            for (int j = 0; j < n3; ++j) {
                switch (this.header.getBytesPerPixel()) {
                    case 1: {
                        byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData(i);
                        this.readRowByte(n3, rectangle, nArray2, nArray, n4, n5, n6, i, byArray, writableRaster3, raster2, j);
                        break;
                    }
                    case 2: {
                        short[] sArray = ((DataBufferUShort)writableRaster2.getDataBuffer()).getData(i);
                        this.readRowUShort(n3, rectangle, nArray2, nArray, n4, n5, n6, i, sArray, writableRaster3, raster2, j);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.processImageProgress(100.0f * (float)j / (float)n3 * (float)i / (float)this.header.getChannels());
                if (n3 - 1 - j < rectangle.y || this.abortRequested()) break;
            }
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
        this.processImageComplete();
        return bufferedImage;
    }

    private void readRowByte(int n, Rectangle rectangle, int[] nArray, int[] nArray2, int n2, int n3, int n4, int n5, byte[] byArray, WritableRaster writableRaster, Raster raster, int n6) throws IOException {
        Closeable closeable;
        int n7;
        if (n6 % n4 != 0 || n - 1 - n6 < rectangle.y || n - 1 - n6 >= rectangle.y + rectangle.height) {
            if (n2 == 0) {
                this.imageInput.skipBytes(byArray.length);
            }
            return;
        }
        if (n2 == 1) {
            n7 = n5 * n + n6;
            this.imageInput.seek(nArray[n7]);
            closeable = new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput, (long)nArray2[n7]), (Decoder)new RLEDecoder()));
        } else {
            closeable = this.imageInput;
        }
        closeable.readFully(byArray, 0, byArray.length);
        if (n3 != 1) {
            for (n7 = 0; n7 < rectangle.width / n3; ++n7) {
                byArray[rectangle.x + n7] = byArray[rectangle.x + n7 * n3];
            }
        }
        this.normalize(byArray, 9, rectangle.width / n3);
        n7 = (n - 1 - n6 - rectangle.y) / n4;
        writableRaster.setDataElements(0, n7, raster);
    }

    private void readRowUShort(int n, Rectangle rectangle, int[] nArray, int[] nArray2, int n2, int n3, int n4, int n5, short[] sArray, WritableRaster writableRaster, Raster raster, int n6) throws IOException {
        Closeable closeable;
        int n7;
        if (n6 % n4 != 0 || n - 1 - n6 < rectangle.y || n - 1 - n6 >= rectangle.y + rectangle.height) {
            if (n2 == 0) {
                this.imageInput.skipBytes(sArray.length * 2);
            }
            return;
        }
        if (n2 == 1) {
            n7 = n5 * n + n6;
            this.imageInput.seek(nArray[n7]);
            closeable = new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput, (long)nArray2[n7]), (Decoder)new RLEDecoder()));
        } else {
            closeable = this.imageInput;
        }
        SGIImageReader.readFully(closeable, sArray);
        if (n3 != 1) {
            for (n7 = 0; n7 < rectangle.width / n3; ++n7) {
                sArray[rectangle.x + n7] = sArray[rectangle.x + n7 * n3];
            }
        }
        this.normalize(sArray, 9, rectangle.width / n3);
        n7 = (n - 1 - n6 - rectangle.y) / n4;
        writableRaster.setDataElements(0, n7, raster);
    }

    private static void readFully(DataInput dataInput, short[] sArray) throws IOException {
        if (dataInput instanceof ImageInputStream) {
            ((ImageInputStream)dataInput).readFully(sArray, 0, sArray.length);
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = dataInput.readShort();
            }
        }
    }

    private void normalize(byte[] byArray, int n, int n2) {
        int n3 = this.header.getMinValue();
        int n4 = this.header.getMaxValue();
        if (n3 != 0 && n4 != 255) {
            for (int i = n; i < n2; ++i) {
                byArray[i] = (byte)((byArray[i] - n3) * 255 / n4);
            }
        }
    }

    private void normalize(short[] sArray, int n, int n2) {
        int n3 = this.header.getMinValue();
        int n4 = this.header.getMaxValue();
        if (n3 != 0 && n4 != 255) {
            for (int i = n; i < n2; ++i) {
                sArray[i] = (byte)((sArray[i] - n3) * 255 / n4);
            }
        }
    }

    private Raster clipRowToRect(Raster raster, Rectangle rectangle, int[] nArray, int n) {
        if (rectangle.contains(raster.getMinX(), 0, raster.getWidth(), 1) && n == 1 && nArray == null) {
            return raster;
        }
        return raster.createChild(rectangle.x / n, 0, rectangle.width / n, 1, 0, 0, nArray);
    }

    private WritableRaster clipToRect(WritableRaster writableRaster, Rectangle rectangle, int[] nArray) {
        if (rectangle.contains(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()) && nArray == null) {
            return writableRaster;
        }
        return writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, nArray);
    }

    private void readHeader() throws IOException {
        if (this.header == null) {
            this.header = SGIHeader.read(this.imageInput);
            this.imageInput.flushBefore(this.imageInput.getStreamPosition());
        }
        this.imageInput.seek(this.imageInput.getFlushedPosition());
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return new SGIMetadata(this.header);
    }

    public static void main(String[] stringArray) throws IOException {
        SGIImageReader sGIImageReader = new SGIImageReader(null);
        for (String string : stringArray) {
            File file = new File(string);
            sGIImageReader.setInput(ImageIO.createImageInputStream(file));
            ImageReadParam imageReadParam = sGIImageReader.getDefaultReadParam();
            imageReadParam.setDestinationType(sGIImageReader.getImageTypes(0).next());
            BufferedImage bufferedImage = sGIImageReader.read(0, imageReadParam);
            System.err.println("image: " + bufferedImage);
            SGIImageReader.showIt((BufferedImage)bufferedImage, (String)file.getName());
            new XMLSerializer((OutputStream)System.out, System.getProperty("file.encoding")).serialize(sGIImageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0"), false);
        }
    }
}

