/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.AbstractMultiPaletteChunk;
import com.twelvemonkeys.imageio.plugins.iff.MutableIndexColorModel;
import java.io.DataInput;
import java.io.IOException;
import javax.imageio.IIOException;

final class PCHGChunk
extends AbstractMultiPaletteChunk {
    static final int PCHG_COMP_NONE = 0;
    static final int PCHG_COMP_HUFFMAN = 1;
    static final int PCHGF_12BIT = 1;
    static final int PCHGF_32BIT = 2;
    static final int PCHGF_USE_ALPHA = 4;
    private int startLine;
    private int changedLines;
    private int lineCount;
    private int totalChanges;
    private int minReg;

    public PCHGChunk(int n) {
        super(1346586695, n);
    }

    @Override
    void readChunk(DataInput dataInput) throws IOException {
        byte[] byArray;
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        this.startLine = dataInput.readShort();
        this.lineCount = dataInput.readUnsignedShort();
        this.changedLines = dataInput.readUnsignedShort();
        this.minReg = dataInput.readUnsignedShort();
        int n3 = dataInput.readUnsignedShort();
        dataInput.readUnsignedShort();
        this.totalChanges = dataInput.readInt();
        switch (n) {
            case 0: {
                byArray = new byte[this.chunkLength - 20];
                dataInput.readFully(byArray);
                break;
            }
            case 1: {
                int n4 = dataInput.readInt();
                int n5 = dataInput.readInt();
                short[] sArray = new short[n4 / 2];
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = dataInput.readShort();
                }
                byte[] byArray2 = new byte[this.chunkLength - 20 - 8 - n4];
                dataInput.readFully(byArray2);
                byte[] byArray3 = new byte[n5];
                PCHGChunk.decompressHuffman(byArray2, byArray3, sArray, byArray3.length);
            }
            default: {
                throw new IIOException("Unknown PCHG compression: " + n);
            }
        }
        this.changes = new MutableIndexColorModel.PaletteChange[this.startLine + this.lineCount][];
        if (this.startLine < 0) {
            int n6 = n3 - this.minReg + 1;
            this.initialChanges = new MutableIndexColorModel.PaletteChange[n6];
        }
        this.parseChanges(byArray, n2);
    }

    static void decompressHuffman(byte[] byArray, byte[] byArray2, short[] sArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = sArray.length - 1;
        int n6 = 0;
        int n7 = 0;
        while (n2 < n) {
            if (n3 == 0) {
                n4 = byArray[n6++];
                n3 = 8;
            }
            if ((n4 & 0x80) != 0) {
                if (sArray[n5] >= 0) {
                    byArray2[n7++] = (byte)sArray[n5];
                    ++n2;
                    n5 = sArray.length - 1;
                } else {
                    n5 += sArray[n5] / 2;
                }
            } else if (sArray[--n5] > 0 && (sArray[n5] & 0x100) != 0) {
                byArray2[n7++] = (byte)sArray[n5];
                ++n2;
                n5 = sArray.length - 1;
            }
            n4 <<= 1;
            --n3;
        }
    }

    private void parseChanges(byte[] byArray, int n) throws IIOException {
        short s;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        if ((n & 1) != 0) {
            bl = true;
        } else if ((n & 2) != 0) {
            if ((n & 4) != 0) {
                new IIOException("Alpha currently not supported.").printStackTrace();
            }
            bl = false;
        } else {
            throw new IIOException("Missing PCHG 12/32 bit flag.");
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = this.changedLines;
        int n9 = 4 * ((this.lineCount + 31) / 32);
        int n10 = 0;
        int n11 = n9;
        int n12 = byArray.length - n9;
        int n13 = 0;
        for (n5 = this.startLine; n8 != 0 && n5 < 0; ++n5) {
            if (n13 == 0) {
                if (n9 == 0) {
                    throw new IIOException("Insufficient data in line mask");
                }
                n6 = byArray[n10++];
                --n9;
                n13 = 8;
            }
            if ((n6 & 0x80) != 0) {
                if (n12 < 2) {
                    throw new IIOException("Insufficient data in SmallLineChanges structures: " + n12);
                }
                n4 = 0;
                if (bl) {
                    n4 = byArray[n11++] & 0xFF;
                    n3 = n4 + (byArray[n11++] & 0xFF);
                } else {
                    n3 = PCHGChunk.toShort(byArray, n11);
                    n11 += 2;
                }
                n12 -= 2;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (n7 >= this.totalChanges) {
                        throw new IIOException("Insufficient data in SmallLineChanges structures (changeCount): " + n7);
                    }
                    if (n12 < 2) {
                        throw new IIOException("Insufficient data in SmallLineChanges structures: " + n12);
                    }
                    if (bl) {
                        s = PCHGChunk.toShort(byArray, n11);
                        n11 += 2;
                        n12 -= 2;
                        int n14 = ((s & 0xF000) >> 12) + (n2 >= n4 ? 16 : 0);
                        this.initialChanges[n14 - this.minReg] = new MutableIndexColorModel.PaletteChange();
                        this.initialChanges[n14 - this.minReg].index = n14;
                        this.initialChanges[n14 - this.minReg].r = (byte)(((s & 0xF00) >> 8) * 17);
                        this.initialChanges[n14 - this.minReg].g = (byte)(((s & 0xF0) >> 4) * 17);
                        this.initialChanges[n14 - this.minReg].b = (byte)((s & 0xF) * 17);
                    } else {
                        s = PCHGChunk.toShort(byArray, n11);
                        n11 += 2;
                        this.initialChanges[s - this.minReg] = new MutableIndexColorModel.PaletteChange();
                        this.initialChanges[s - this.minReg].index = s;
                        int n15 = ++n11;
                        this.initialChanges[s - this.minReg].r = byArray[n15];
                        int n16 = ++n11;
                        this.initialChanges[s - this.minReg].b = byArray[n16];
                        int n17 = ++n11;
                        ++n11;
                        this.initialChanges[s - this.minReg].g = byArray[n17];
                        n12 -= 6;
                    }
                    ++n7;
                }
                --n8;
            }
            n6 <<= 1;
            --n13;
        }
        for (n5 = this.startLine; n8 != 0 && n5 < this.changes.length; ++n5) {
            if (n13 == 0) {
                if (n9 == 0) {
                    throw new IIOException("Insufficient data in line mask");
                }
                n6 = byArray[n10++];
                --n9;
                n13 = 8;
            }
            if ((n6 & 0x80) != 0) {
                if (n12 < 2) {
                    throw new IIOException("Insufficient data in SmallLineChanges structures: " + n12);
                }
                n4 = 0;
                if (bl) {
                    n4 = byArray[n11++] & 0xFF;
                    n3 = n4 + (byArray[n11++] & 0xFF);
                } else {
                    n3 = PCHGChunk.toShort(byArray, n11);
                    n11 += 2;
                }
                n12 -= 2;
                this.changes[n5] = new MutableIndexColorModel.PaletteChange[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    if (n7 >= this.totalChanges) {
                        throw new IIOException("Insufficient data in SmallLineChanges structures (changeCount): " + n7);
                    }
                    if (n12 < 2) {
                        throw new IIOException("Insufficient data in SmallLineChanges structures: " + n12);
                    }
                    if (bl) {
                        s = PCHGChunk.toShort(byArray, n11);
                        n11 += 2;
                        n12 -= 2;
                        int n18 = ((s & 0xF000) >> 12) + (n2 >= n4 ? 16 : 0);
                        MutableIndexColorModel.PaletteChange paletteChange = new MutableIndexColorModel.PaletteChange();
                        paletteChange.index = n18;
                        paletteChange.r = (byte)(((s & 0xF00) >> 8) * 17);
                        paletteChange.g = (byte)(((s & 0xF0) >> 4) * 17);
                        paletteChange.b = (byte)((s & 0xF) * 17);
                        this.changes[n5][n2] = paletteChange;
                    } else {
                        s = PCHGChunk.toShort(byArray, n11);
                        n11 += 2;
                        MutableIndexColorModel.PaletteChange paletteChange = new MutableIndexColorModel.PaletteChange();
                        paletteChange.index = s;
                        int n19 = ++n11;
                        paletteChange.r = byArray[n19];
                        int n20 = ++n11;
                        paletteChange.b = byArray[n20];
                        int n21 = ++n11;
                        ++n11;
                        paletteChange.g = byArray[n21];
                        this.changes[n5][n2] = paletteChange;
                        n12 -= 6;
                    }
                    ++n7;
                }
                --n8;
            }
            n6 <<= 1;
            --n13;
        }
        if (n7 != this.totalChanges) {
            new IIOException(String.format("Got %d change structures, chunk header reports %d", n7, this.totalChanges)).printStackTrace();
        }
    }

    private static short toShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }
}

