/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JMenu;
import net.sf.portecle.gui.JMenuItemRecentFile;

public class JMenuRecentFiles
extends JMenu {
    private static final int MAX_LENGTH = 9;
    private final JMenuItemRecentFile[] m_jmirf;
    private final int m_iIndex;

    public JMenuRecentFiles(String string, int n, int n2) {
        super(string);
        this.m_jmirf = new JMenuItemRecentFile[Math.min(n, 9)];
        this.m_iIndex = n2;
    }

    private void removeAllRecentFiles() {
        for (JMenuItemRecentFile jMenuItemRecentFile : this.m_jmirf) {
            if (jMenuItemRecentFile == null) break;
            this.remove(jMenuItemRecentFile);
        }
    }

    private void addAllRecentFiles() {
        for (int i = 0; i < this.m_jmirf.length && this.m_jmirf[i] != null; ++i) {
            this.add((Component)this.m_jmirf[i], this.m_iIndex + i + 1);
        }
    }

    private boolean recentFiles() {
        boolean bl = true;
        for (JMenuItemRecentFile jMenuItemRecentFile : this.m_jmirf) {
            if (jMenuItemRecentFile == null) continue;
            bl = false;
            break;
        }
        return !bl;
    }

    private int findRecentFile(File file) {
        int n = -1;
        for (int i = 0; i < this.m_jmirf.length && this.m_jmirf[i] != null; ++i) {
            if (!file.equals(this.m_jmirf[i].getFile())) continue;
            n = i;
            break;
        }
        return n;
    }

    public void add(JMenuItemRecentFile jMenuItemRecentFile) {
        int n;
        if (!this.recentFiles()) {
            this.insertSeparator(this.m_iIndex);
        }
        if ((n = this.findRecentFile(jMenuItemRecentFile.getFile())) == 0) {
            return;
        }
        this.removeAllRecentFiles();
        jMenuItemRecentFile.setPosition(1);
        if (n != -1) {
            for (int i = 0; i <= n; ++i) {
                JMenuItemRecentFile jMenuItemRecentFile2 = this.m_jmirf[i];
                this.m_jmirf[i] = jMenuItemRecentFile;
                jMenuItemRecentFile = jMenuItemRecentFile2;
                jMenuItemRecentFile.setPosition(i + 2);
            }
        } else {
            for (int i = 0; i < this.m_jmirf.length; ++i) {
                JMenuItemRecentFile jMenuItemRecentFile3 = this.m_jmirf[i];
                this.m_jmirf[i] = jMenuItemRecentFile;
                jMenuItemRecentFile = jMenuItemRecentFile3;
                if (jMenuItemRecentFile != null) {
                    jMenuItemRecentFile.setPosition(i + 2);
                    continue;
                }
                break;
            }
        }
        this.addAllRecentFiles();
    }

    public File[] getRecentFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (JMenuItemRecentFile jMenuItemRecentFile : this.m_jmirf) {
            if (jMenuItemRecentFile == null) break;
            arrayList.add(jMenuItemRecentFile.getFile());
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }
}

